// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: FunctionDefinitionNode.cs 263 2010-01-16 13:12:35Z panacoran $

using System;
using System.Collections.Generic;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ֐`̃m[h\NXB
	/// </summary>
	public class FunctionDefinitionNode : Node
	{
		/// <summary>
		/// ֐
		/// </summary>
		private string name;
        /// <summary>
        /// ̌
        /// </summary>
        private int argnum;
		/// <summary>
		/// m[h̃Xg
		/// </summary>
		private List<Node> nodeList = new List<Node>();
        /// <summary>
        /// X^bNt[̑傫
        /// </summary>
        int framesize;

		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ƂthrowB
		/// </exception>
        /// <return>
        /// ͂ʂ̃m[hB
        /// </return>
		public override Node Parse()
		{
			Token = Scanner.Token;

			// ֐̃`FbN
            Scanner.Scan();
			if(Scanner.Token.Type != TokenType.FunctionName)
				throw new ParseException("function name expected", Scanner.Token);
			name = Scanner.Token.Value;

            // ƃ[Jϐp̋L\pӂB
            LvtStack.Push(new Dictionary<string, int>());
            LvtStack.Peek()["at"] = 0;
			// ̃`FbN
			Scanner.Scan();
			if (Scanner.Token.Value != "(")
			{
				if (Scanner.Token.Value != ";")
					throw new ParseException("';' expected", Scanner.Token);
			}
			else
			{
                Scanner.Scan();
				if (Scanner.Token.Value == ")")
				{
                    Scanner.Scan();
                    if (Scanner.Token.Value != ";")
                        throw new ParseException("';' expected", Scanner.Token);
				}
				else
				{
					do
					{
						if (Scanner.Token.Type != TokenType.LocalVariable)
							throw new ParseException("function argument expected", Scanner.Token);
                        Dictionary<string, int> lvt = LvtStack.Peek();
                        if (lvt.ContainsKey(Scanner.Token.Value))
                            throw new ParseException("duplicate argument name", Scanner.Token);
                        argnum++;
                        lvt[Scanner.Token.Value] = lvt.Count;
                        Scanner.Scan();
						if (Scanner.Token.Value == ")")
						{
							Scanner.Scan();
							if (Scanner.Token.Value != ";")
								throw new ParseException("';' expected", Scanner.Token);
							break;
						}
						else if (Scanner.Token.Value != ",")
							throw new ParseException("',' or ')' expected", Scanner.Token);
					}
                    while (Scanner.Scan());
				}
			}

			// {̂̃`FbN
			while (Scanner.Scan())
			{
				if (Scanner.Token.Value == "end")
				{
                    Scanner.Scan();
					if (Scanner.Token.Value != ";")
						throw new ParseException("';' expected", Scanner.Token);
                    framesize = LvtStack.Peek().Count;
                    LvtStack.Pop();
					return this;
				}
				nodeList.Add(new StatementNode().Parse());
			}

			throw new ParseException("unexpected EOF", Token);
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			// ֐e[uɓo^
            FunctionType ft = new FunctionType(name, argnum);
			if(resource.FunctionTable.ContainsKey(ft))
				throw new RuntimeException("function is already defined --- " + ft.ToString(), Token);
			resource.FunctionTable[ft] = this;
			return null;
		}

        /// <summary>
        /// m[h̃Xg擾B
        /// </summary>
        public List<Node> Nodes
        {
            get { return nodeList; }
        }

        /// <summary>
        /// X^bNt[̑傫擾B
        /// </summary>
        public int FrameSize
        {
            get { return framesize; }
        }
	}
}
