// Copyright (C) 2004 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: EditBrandListDialog.cs 263 2010-01-16 13:12:35Z panacoran $

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Protra.Lib.Db;

namespace PtSim.Dialogs
{
	/// <summary>
	/// XgҏW邽߂̃_CAOłB
	/// </summary>
	public class EditBrandListDialog : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label labelBrandList;
		private System.Windows.Forms.Label labelContent;
		private System.Windows.Forms.ListBox listBoxBrandList;
		private System.Windows.Forms.ListView listViewContent;
		private System.Windows.Forms.ColumnHeader columnHeaderMarket;
		private System.Windows.Forms.ColumnHeader columnHeaderCode;
		private System.Windows.Forms.ColumnHeader columnHeaderName;
		private System.Windows.Forms.Button buttonAdd;
		private System.Windows.Forms.Button buttonEdit;
		private System.Windows.Forms.Button buttonDelete;
		private System.Windows.Forms.Button buttonExit;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// RXgN^
		/// </summary>
		public EditBrandListDialog()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.labelBrandList = new System.Windows.Forms.Label();
			this.labelContent = new System.Windows.Forms.Label();
			this.listBoxBrandList = new System.Windows.Forms.ListBox();
			this.listViewContent = new System.Windows.Forms.ListView();
			this.columnHeaderMarket = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderCode = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderName = new System.Windows.Forms.ColumnHeader();
			this.buttonAdd = new System.Windows.Forms.Button();
			this.buttonEdit = new System.Windows.Forms.Button();
			this.buttonDelete = new System.Windows.Forms.Button();
			this.buttonExit = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// labelBrandList
			// 
			this.labelBrandList.Location = new System.Drawing.Point(8, 8);
			this.labelBrandList.Name = "labelBrandList";
			this.labelBrandList.Size = new System.Drawing.Size(56, 16);
			this.labelBrandList.TabIndex = 0;
			this.labelBrandList.Text = "Xg";
			// 
			// labelContent
			// 
			this.labelContent.Location = new System.Drawing.Point(8, 120);
			this.labelContent.Name = "labelContent";
			this.labelContent.Size = new System.Drawing.Size(32, 16);
			this.labelContent.TabIndex = 6;
			this.labelContent.Text = "e";
			// 
			// listBoxBrandList
			// 
			this.listBoxBrandList.ItemHeight = 12;
			this.listBoxBrandList.Location = new System.Drawing.Point(8, 24);
			this.listBoxBrandList.Name = "listBoxBrandList";
			this.listBoxBrandList.Size = new System.Drawing.Size(128, 88);
			this.listBoxBrandList.Sorted = true;
			this.listBoxBrandList.TabIndex = 1;
			this.listBoxBrandList.SelectedIndexChanged += new System.EventHandler(this.listBoxBrandList_SelectedIndexChanged);
			// 
			// listViewContent
			// 
			this.listViewContent.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.columnHeaderMarket,
																							  this.columnHeaderCode,
																							  this.columnHeaderName});
			this.listViewContent.FullRowSelect = true;
			this.listViewContent.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.listViewContent.Location = new System.Drawing.Point(8, 136);
			this.listViewContent.Name = "listViewContent";
			this.listViewContent.Size = new System.Drawing.Size(280, 184);
			this.listViewContent.TabIndex = 7;
			this.listViewContent.View = System.Windows.Forms.View.Details;
			// 
			// columnHeaderMarket
			// 
			this.columnHeaderMarket.Text = "s";
			this.columnHeaderMarket.Width = 69;
			// 
			// columnHeaderCode
			// 
			this.columnHeaderCode.Text = "R[h";
			this.columnHeaderCode.Width = 59;
			// 
			// columnHeaderName
			// 
			this.columnHeaderName.Text = "";
			this.columnHeaderName.Width = 114;
			// 
			// buttonAdd
			// 
			this.buttonAdd.Location = new System.Drawing.Point(144, 24);
			this.buttonAdd.Name = "buttonAdd";
			this.buttonAdd.Size = new System.Drawing.Size(64, 23);
			this.buttonAdd.TabIndex = 2;
			this.buttonAdd.Text = "ǉ";
			this.buttonAdd.Click += new System.EventHandler(this.buttonAdd_Click);
			// 
			// buttonEdit
			// 
			this.buttonEdit.Location = new System.Drawing.Point(144, 56);
			this.buttonEdit.Name = "buttonEdit";
			this.buttonEdit.Size = new System.Drawing.Size(64, 23);
			this.buttonEdit.TabIndex = 3;
			this.buttonEdit.Text = "ҏW";
			this.buttonEdit.Click += new System.EventHandler(this.buttonEdit_Click);
			// 
			// buttonDelete
			// 
			this.buttonDelete.Location = new System.Drawing.Point(144, 88);
			this.buttonDelete.Name = "buttonDelete";
			this.buttonDelete.Size = new System.Drawing.Size(64, 23);
			this.buttonDelete.TabIndex = 4;
			this.buttonDelete.Text = "폜";
			this.buttonDelete.Click += new System.EventHandler(this.buttonDelete_Click);
			// 
			// buttonExit
			// 
			this.buttonExit.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonExit.Location = new System.Drawing.Point(216, 24);
			this.buttonExit.Name = "buttonExit";
			this.buttonExit.TabIndex = 5;
			this.buttonExit.Text = "I";
			// 
			// EditBrandListDialog
			// 
			this.AcceptButton = this.buttonExit;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(298, 333);
			this.ControlBox = false;
			this.Controls.Add(this.buttonExit);
			this.Controls.Add(this.buttonDelete);
			this.Controls.Add(this.buttonEdit);
			this.Controls.Add(this.buttonAdd);
			this.Controls.Add(this.listViewContent);
			this.Controls.Add(this.listBoxBrandList);
			this.Controls.Add(this.labelContent);
			this.Controls.Add(this.labelBrandList);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "EditBrandListDialog";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "XgҏW";
			this.Load += new System.EventHandler(this.EditBrandListDialog_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void EditBrandListDialog_Load(object sender, System.EventArgs e)
		{
			BrandList[] brandLists = BrandListTable.GetAllRecords();
			foreach(BrandList brandList in brandLists)
				this.listBoxBrandList.Items.Add(new BrandListItem(brandList));
			if(this.listBoxBrandList.Items.Count > 0)
				this.listBoxBrandList.SelectedIndex = 0;
		}

		private void buttonAdd_Click(object sender, System.EventArgs e)
		{
			EditBrandListContentDialog dialog = new EditBrandListContentDialog(null);
			DialogResult result = dialog.ShowDialog(this);
			if(result == DialogResult.OK)
			{
				object item = new BrandListItem(dialog.BrandList);
				this.listBoxBrandList.Items.Add(item);
				this.listBoxBrandList.SelectedItem = item;
			}
		}

		private void buttonEdit_Click(object sender, System.EventArgs e)
		{
			object item = this.listBoxBrandList.SelectedItem;
			if(item != null)
			{
				BrandList brandList = ((BrandListItem)item).BrandList;
				EditBrandListContentDialog dialog = new EditBrandListContentDialog(brandList);
				DialogResult result = dialog.ShowDialog(this);
				if(result == DialogResult.OK)
				{
					this.listBoxBrandList.Items.Remove(item);
					item = new BrandListItem(dialog.BrandList);
					this.listBoxBrandList.Items.Add(item);
					this.listBoxBrandList.SelectedItem = item;
				}
			}
		}

		private void buttonDelete_Click(object sender, System.EventArgs e)
		{
			object item = this.listBoxBrandList.SelectedItem;
			if(item != null)
			{
				BrandList brandList = ((BrandListItem)item).BrandList;
				string msg = string.Format(
					"{0}폜܂B낵łH", brandList.Name);
				DialogResult result = MessageBox.Show(
					this, msg, "mF", MessageBoxButtons.OKCancel,
					MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1);
				if(result == DialogResult.OK)
				{
					int index = this.listBoxBrandList.SelectedIndex;
					this.listBoxBrandList.Items.Remove(item);
					brandList.Delete();
					if(index < this.listBoxBrandList.Items.Count)
						this.listBoxBrandList.SelectedIndex = index;
					else if(this.listBoxBrandList.Items.Count > 0)
						this.listBoxBrandList.SelectedIndex = index - 1;
				}
			}
		}

		private void listBoxBrandList_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.listViewContent.Items.Clear();
			ArrayList itemList = new ArrayList();
			object item = this.listBoxBrandList.SelectedItem;
			if(item != null) 
			{
				BrandList brandList = ((BrandListItem)item).BrandList;
				Brand[] brands = brandList.Brands;
				foreach(Brand brand in brands)
					itemList.Add(new ListViewItem(new string[]{
						brand.Market.Name,
						brand.Code.ToString(),
						brand.Name
					}));
			}
			ListViewItem[] items = (ListViewItem[])itemList.ToArray(typeof(ListViewItem));
			this.listViewContent.Items.AddRange(items);
		}
	}

	/// <summary>
	/// XgێACełB
	/// </summary>
	public class BrandListItem : IComparable
	{
		/// <summary>
		/// Xg
		/// </summary>
		private BrandList brandList;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="brandList"></param>
		public BrandListItem(BrandList brandList)
		{
			this.brandList = brandList;
		}

		/// <summary>
		/// Xg擾܂B
		/// </summary>
		public BrandList BrandList
		{
			get { return brandList; }
		}

		/// <summary>
		/// w肵IuWFNgƑ召r܂B
		/// </summary>
		/// <param name="o">IuWFNg</param>
		/// <returns>rʂłB</returns>
		public int CompareTo(object o)
		{
			BrandList _brandList = ((BrandListItem)o).brandList;
			int c = brandList.Name.CompareTo(_brandList.Name); 
			return c != 0 ? c : brandList.Id - _brandList.Id;
		}

		/// <summary>
		/// rs܂B
		/// </summary>
		/// <param name="o">IuWFNg</param>
		/// <returns>rʂłB</returns>
		public override bool Equals(object o)
		{
			if(o is BrandListItem)
			{
				BrandListItem obj = (BrandListItem)o;
				return brandList.Id == obj.brandList.Id;
			}

			return false;
		}

		/// <summary>
		/// nbVlvZ܂B
		/// </summary>
		/// <returns>nbVlłB</returns>
		public override int GetHashCode()
		{
			return brandList.GetHashCode();
		}

		/// <summary>
		/// \߂܂B
		/// </summary>
		/// <returns>\łB</returns>
		public override string ToString()
		{
			return brandList.Name;
		}
	}
}
