// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: IfStatementNode.cs,v 1.3 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// if̃m[h\NXłB
	/// </summary>
	public class IfStatementNode : Node
	{
		/// <summary>
		/// ̃m[h
		/// </summary>
		private Node condNode;
		/// <summary>
		/// m[h̃Xg
		/// </summary>
		private ArrayList nodeList = new ArrayList();
		/// <summary>
		/// elsif܂else
		/// </summary>
		private IfStatementNode nextNode;

		/// <summary>
		/// ͂܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// ɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="context">ReLXg</param>
		public override void Parse(Context context)
		{
			this.ContextToken = (ContextToken)context.Current;

			if(! context.MoveNext())
				throw new ParseException("expression is expected", this.ContextToken);
			condNode = new ExpressionNode();
			condNode.Parse(context);

			ContextToken ct = (ContextToken)context.Current;
			string token = ct.ToString();
			if(token != ";")
				throw new ParseException("';' expected", this.ContextToken);

			while(context.MoveNext())
			{
				ct = (ContextToken)context.Current;
				token = ct.ToString();
				if(token == "end")
				{
					context.MoveNext();
					ct = (ContextToken)context.Current;
					token = ct.ToString();
					if(token != ";")
						throw new ParseException("';' expected", this.ContextToken);
					return;
				}
				else if(token == "elsif ")
				{
					nextNode = new IfStatementNode();
					nextNode.Parse(context);
					return;
				}
				else if(token == "else")
				{
					nextNode = ParseElse(context);
					return;
				}

				Node node = new StatementNode();
				node.Parse(context);
				nodeList.Add(node);
			}

			throw new ParseException("unexpected EOF was detected", this.ContextToken);
		}

		private static IfStatementNode ParseElse(Context context)
		{
			context.MoveNext();
			ContextToken ct = (ContextToken)context.Current;
			string token = ct.ToString();
			if(token != ";")
				throw new ParseException("';' expected", ct);

			IfStatementNode node = new IfStatementNode();
			node.condNode = new LiteralNode(new Value(true));
			while(context.MoveNext())
			{
				ct = (ContextToken)context.Current;
				token = ct.ToString();
				if(token == "end")
				{
					context.MoveNext();
					ct = (ContextToken)context.Current;
					token = ct.ToString();
					if(token != ";")
						throw new ParseException("';' expected", ct);
					return node;
				}

				Node snode = new StatementNode();
				snode.Parse(context);
				node.nodeList.Add(snode);
			}

			throw new ParseException("unexpected EOF was detected", ct);
		}

		/// <summary>
		/// \؂ȗ܂B
		/// </summary>
		/// <returns>ȗꂽm[h</returns>
		public override Node Simplify()
		{
			condNode = condNode.Simplify();
			for(int i = 0; i < nodeList.Count; i++)
			{
				Node node = (Node)nodeList[i];
				nodeList[i] = node.Simplify();
			}
			if(nextNode != null)
				nextNode = (IfStatementNode)nextNode.Simplify();
			return this;
		}

		/// <summary>
		/// vOs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			Value val = condNode.Execute(resource, at);
			if(val != null && val.IsTrue)
			{
				foreach(Node node in nodeList)
					node.Execute(resource, at);
			}
			else if(nextNode != null)
			{
				nextNode.Execute(resource, at);
			}

			return null;
		}
	}
}
