﻿// Copyright (C) 2008, 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: MathBuiltins.cs 306 2010-03-19 13:21:22Z panacoran $

using System;

namespace Protra.Lib.Lang
{
    /// <summary>
    /// 数学関係の組み込み関数を実行するクラス。
    /// </summary>
    public class MathBuiltins : Builtins
    {
        static readonly Random random = new Random();

        /// <summary>
        /// 組み込み関数を実行する。
        /// </summary>
        /// <param name="name">名前</param>
        /// <param name="args">引数</param>
        /// <param name="at">atパラメータ</param>
        /// <returns></returns>
        public override Value Invoke(string name, Value[] args, int at)
        {
            if (name == "Random")
            {
                if (args.Length == 0)
                    return new Value(random.NextDouble());
                if (args.Length == 1)
                    return new Value(random.Next((int)(args[0].Cast(Value.Type.Int).InnerValue)));
            }
            else if (args.Length == 1)
            {
                double d = (double)(args[0].Cast(Value.Type.Float).InnerValue);
                switch (name)
                {
                case "Exp":
                    return new Value(Math.Exp(d));
                case "Log":
                    return new Value(Math.Log(d));
                case "Sqrt":
                    return new Value(Math.Sqrt(d));
                case "Sin":
                    return new Value(Math.Sin(d));
                case "Cos":
                    return new Value(Math.Cos(d));
                case "Tan":
                    return new Value(Math.Tan(d));
                case "Asin":
                    return new Value(Math.Asin(d));
                case "Acos":
                    return new Value(Math.Acos(d));
                case "Atan":
                    return new Value(Math.Atan(d));
                default:
                    return base.Invoke(name, args, at);
                }
            }
            else if (args.Length == 2 && name == "Pow")
            {
                double x = (double)(args[0].Cast(Value.Type.Float).InnerValue);
                double y = (double)(args[1].Cast(Value.Type.Float).InnerValue);
                return new Value(Math.Pow(x, y));
            }
            return base.Invoke(name, args, at);
        }
    }
}
