// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004-2006 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: SystemLog.cs,v 1.8 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Db
{
	/// <summary>
	/// ̎ނ\B
	/// </summary>
	public enum Order
	{
		/// <summary>
		/// B
		/// </summary>
		Buy,
		/// <summary>
		/// B
		/// </summary>
		Sell
	}

	/// <summary>
	/// SystemLoge[ũR[h\B
	/// </summary>
	public class SystemLog: IRecord
	{
		private int systemId;
		private int brandId;
		private DateTime date;
		private int price;
		private int number;
		private Order order;

		/// <summary>
		/// ̃RXgN^
		/// </summary>
		public SystemLog() {}

		/// <summary>
		/// RXgN^
		/// </summary>
		public SystemLog(int systemId, int brandId, DateTime date,
						 int price, int number, Order order)
		{
			this.systemId = systemId;
			this.brandId = brandId;
			this.date = date;
			this.price = price;
			this.number = number;
			this.order = order;
		}

		/// <summary>
		/// VXeId擾B
		/// </summary>
		public int SystemId
		{
			get { return systemId; }
		}

		/// <summary>
		/// VXeIDɑΉSystemIuWFNg擾B
		/// </summary>
		public TradingSystem System
		{
			get { return SystemTable.GetRecord(systemId); }
		}

		/// <summary>
		/// ID擾B
		/// </summary>
		public int BrandId
		{
			get { return brandId; }
		}

		/// <summary>
		/// IDɑΉBrandIuWFNg擾B
		/// </summary>
		public Brand Brand
		{
			get { return BrandTable.GetRecord(brandId); }
		}

		/// <summary>
		/// Date擾B
		/// </summary>
		public DateTime Date
		{
			get { return date; }
		}

		/// <summary>
		/// i擾B
		/// </summary>
		public int Price
		{
			get { return price; }
		}

		/// <summary>
		/// ʂ擾B
		/// </summary>
		public int Number
		{
			get { return number; }
		}

		/// <summary>
		/// Order擾܂B
		/// </summary>
		public Order Order
		{
			get { return order; }
		}

		/// <summary>
		/// f[^x[X̃R[hIuWFNgɕϊB
		/// </summary>
		/// <param name="values">lCeBu`̒l̔z</param>
		/// <returns>ϊSystemLogIuWFNgԂB</returns>
		public Object ToObject(Object[] values)
		{
			return new SystemLog((int)values[0], // @SystemId
								 (int)values[1], // @BrandId
								 (DateTime)values[2], // @Date
								 (int)values[3], // @Price
								 (int)values[4], // @Number
								 (Order)values[5]); // @Order
		}

		/// <summary>
		/// CX^X𕶎\ɕϊB
		/// </summary>
		/// <returns>\</returns>
		public override string ToString()
		{
			return string.Format(
				"SystemLog[SystemId={0}, BrandId={1}, {2}, " +
				"Price={3}, Number={4}, Order={5}]",
				systemId, brandId, date, price, number, order);
		}
	}

	/// <summary>
	/// SystemLoge[u𑀍삷B
	/// </summary>
	public class SystemLogTable
	{
		private static Connection conn;
		private static Connection Conn
		{
			get 
			{
				if (conn != null)
					return conn;
				conn = new Connection("protra");
				return conn;
			}
		}

		/// <summary>
		/// w肳ꂽVXeIDƖID̃O擾B
		/// </summary>
		/// <param name="systemId">VXeID</param>
		/// <param name="brandId">ID</param>
		/// <returns>tɃ\[gꂽSystemLogIuWFNg̔zB</returns>
		public static SystemLog[] GetRecords(int systemId, int brandId)
		{
			string sql = string.Format(
				"SELECT * FROM SystemLog " +
				"WHERE @SystemId={0} AND @BrandId={1} ORDER BY @Date",
				systemId, brandId);
			ArrayList result = Conn.Query(sql, new SystemLog());
			return (SystemLog[])result.ToArray(typeof(SystemLog));
		}

		/// <summary>
		/// w肳ꂽVXeIDƎwԂ̃O擾B
		/// </summary>
		/// <param name="systemId">VXeID</param>
		/// <param name="minDate">t̍ŏl</param>
		/// <param name="maxDate">t̍ől</param>
		/// <returns>t̍~Ƀ\[gꂽSystemLogIuWFNg̔zB</returns>
		public static SystemLog[] GetRecords(
			int systemId, DateTime minDate, DateTime maxDate)
		{
			string sql = string.Format(
				"SELECT * FROM SystemLog " +
				"WHERE @SystemId={0} AND @Date>=#{1}# AND @Date<=#{2}# " +
				"ORDER BY @Date DESC, @BrandId", systemId,
				minDate.ToString("d"),
				maxDate.ToString("d"));
			ArrayList result = Conn.Query(sql, new SystemLog());
			return (SystemLog[])result.ToArray(typeof(SystemLog));
		}

		/// <summary>
		/// R[hǉB
		/// </summary>
		/// <param name="systemId">VXeID</param>
		/// <param name="brandId">ID</param>
		/// <param name="date">t</param>
		/// <param name="price">i</param>
		/// <param name="number"></param>
		/// <param name="order"></param>
		public static SystemLog Add(
			int systemId, int brandId, DateTime date, int price, int number, Order order)
		{
			string sql = string.Format(
				"INSERT INTO SystemLog VALUES({0}, {1}, #{2}#, {3}, {4}, {5})",
				systemId, brandId, date.ToString("d"),
				price, number, (int)order);
			Conn.Execute(sql);
			return new SystemLog(systemId, brandId, date,
								 price, number, order);
		}

		/// <summary>
		/// w肳ꂽVXeID̃O폜B
		/// </summary>
		/// <param name="systemId">VXeID</param>
		public static void Delete(int systemId)
		{
			string sql = string.Format(
				"DELETE FROM SystemLog WHERE @SystemId={0}", systemId);
			Conn.Execute(sql);
		}

		/// <summary>
		/// w肳ꂽVXeIDƖID̃O폜
		/// </summary>
		/// <param name="systemId">VXeID</param>
		/// <param name="brandId">ID</param>
		public static void Delete(int systemId, int brandId)
		{
			string sql = string.Format(
				"DELETE FROM SystemLog WHERE @SystemId={0} AND @BrandId={1}",
				systemId, brandId);
			Conn.Execute(sql);
		}

		/// <summary>
		/// Sf[^폜B
		/// </summary>
		public static void Delete()
		{
			string sql = "DELETE FROM SystemLog";
			Conn.Execute(sql);
		}
	}
}
