﻿// Copyright (C) 2008, 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ListViewEx.cs 475 2013-06-30 01:11:58Z panacoran $

using System.Windows.Forms;

namespace PtSim.Controls
{
    /// <summary>
    /// ListViewクラスのバグを隠蔽するためのクラス。
    /// </summary>
    public class ListViewEx : ListView
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ListViewEx()
        {
            OwnerDraw = true;
        }

        /// <summary>
        /// デフォルトの描画をさせる。
        /// </summary>
        /// <param name="e">イベントデータ</param>
        protected override void OnDrawColumnHeader(DrawListViewColumnHeaderEventArgs e)
        {
            e.DrawDefault = true;
            base.OnDrawColumnHeader(e);
        }

        /// <summary>
        /// デフォルトの描画をさせる。
        /// </summary>
        /// <param name="e">イベントデータ</param>
        protected override void OnDrawItem(DrawListViewItemEventArgs e)
        {
            e.DrawDefault = true;
            base.OnDrawItem(e);
        }

        /// <summary>
        /// デフォルトの描画をさせる。
        /// </summary>
        /// <param name="e">イベントデータ。</param>
        protected override void OnDrawSubItem(DrawListViewSubItemEventArgs e)
        {
            e.DrawDefault = true;
            base.OnDrawSubItem(e);
        }
    }
}