// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: SimulateBuiltins.cs,v 1.1 2008-03-26 19:49:42 panacoran Exp $

using System;
using Protra.Lib.Db;

namespace Protra.Lib.Lang
{
    delegate void AppendTextDelegate(string msg);

    /// <summary>
    /// V~[V֘Ȃgݍ݊֐NXB
    /// </summary>
    class SimulateBuiltins : BasicBuiltins
    {
        TradingSystem system;
        AppendTextDelegate appendText;

        public TradingSystem System
        {
            set { system = value; }
            get { return system; }
        }

        public AppendTextDelegate AppendText
        {
            set { appendText = value; }
            get { return appendText; }
        }

        public override Value Invoke(string name, Value[] args, int at)
        {
            if (args.Length == 1)
            {
                string msg;
                switch (name)
                {
                case "Print":
                    msg = (args[0] == null) ? "null" : args[0].InnerValue.ToString();
                    break;
                case "PrintLog":
                    msg = (args[0] == null) ? "null" : args[0].InnerValue.ToString();
                    msg = string.Format(
                        "{0} {1} {2} {3}",
                        Brand.Code, Brand.Name,
                        Prices[Index + at].Date.ToString("yy/MM/dd"), msg);
                    break;
                default:
                    return base.Invoke(name, args, at);
                }
                appendText(msg + "\r\n");
                return null;
            }
            else if (args.Length == 2)
            {
                int price;
                int number;
                string msg;
                switch (name)
                {
                case "Buy":
                    price = (int)args[0].InnerValue;
                    number = (int)args[1].InnerValue;
                    SystemLogTable.Add(
                        system.Id, Brand.Id, Prices[Index + at].Date, price, number, Order.Buy);
                    msg = string.Format(
                        "{0} {1} {2} {3}~ {4} \r\n",
                        Brand.Code, Brand.Name,
                        Prices[Index + at].Date.ToString("yy/MM/dd"),
                        price, number);
                    break;
                case "Sell":
                    price = (int)args[0].InnerValue;
                    number = (int)args[1].InnerValue;
                    SystemLogTable.Add(
                        system.Id, Brand.Id, Prices[Index + at].Date, price, number, Order.Sell);
                    msg = string.Format(
                        "{0} {1} {2} {3}~ {4} \r\n",
                        Brand.Code, Brand.Name,
                        Prices[Index + at].Date.ToString("yy/MM/dd"),
                        price, number);
                    break;
                default:
                    return base.Invoke(name, args, at);
                }
                appendText(msg);
                return null;
            }
            else
                return base.Invoke(name, args, at);
        }
    }
}
