// Copyright (C) 2007 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Utils.cs,v 1.4 2007-12-27 08:34:39 panacoran Exp $

using System;

namespace Protra.Lib
{
	/// <summary>
	/// [eBeB֐񋟂B
	/// </summary>
	public class Utils
	{
		/// <summary>
		/// w肳ꂽtɎsꂪJĂ邩ԂB
		/// </summary>
		/// <param name="d">tw肷B</param>
		/// <returns></returns>
		public static bool IsMarketOpen(DateTime d)
		{
			// y
			if (d.DayOfWeek == DayOfWeek.Saturday ||
				d.DayOfWeek == DayOfWeek.Sunday)
				return false;
			// NNn
			if ((d.Month == 12 && d.Day == 31) ||
				(d.Month == 1 && d.Day <= 3))
				return false;		
			return !IsHoliday(d);
		}

		/// <summary>
		/// w肳ꂽtT̍Ō̊JԂB
		/// </summary>
		/// <param name="d"></param>
		/// <returns></returns>
		public static bool IsLastOpenDateOfWeek(DateTime d)
		{
			for (d = d.AddDays(1); d.DayOfWeek < DayOfWeek.Saturday; d = d.AddDays(1))
				if (IsMarketOpen(d))
					return false;
			return true;
		}

		static bool IsHoliday(DateTime d)
		{
			// Ȃx
			if ((d.Month == 1 && d.Day == 1) ||
				(d.Month == 2 && d.Day == 11) ||
				(d.Month == 4 && d.Day == 29) ||
				(d.Month == 5 && (d.Day >= 3 && d.Day <= 5)) ||
				(d.Month == 11 && (d.Day == 3 || d.Day == 23)) ||
				(d.Month == 12 && d.Day == 23))
				return true;
			// tƏH(1980`2099NɑΉ)
			if (d.Month == 3 &&
				d.Day == (int)(20.8431 + 0.242194 * (d.Year - 1980) - (d.Year -1980) / 4))
				return true;
			if (d.Month == 9 &&
				d.Day == (int)(23.2488 + 0.242194 * (d.Year - 1980) - (d.Year -1980) / 4))
				return true;
			// nbs[}f[
			if (d.Year < 2000)
			{
				if ((d.Month == 1 && d.Day == 15) ||
					(d.Month == 10 && d.Day == 10))
					return true;
			}
			else
			{
				if ((d.Month == 1 || d.Month == 10) &&
					(d.Day >= 8 && d.Day <= 14))
					return d.DayOfWeek == DayOfWeek.Monday;
			}
			if (d.Year < 2003)
			{
				if ((d.Month == 7 && d.Day == 20) ||
					(d.Month == 9 && d.Day == 15))
					return true;
			}
			else
			{
				if ((d.Month == 7 || d.Month == 9) &&
					(d.Day >= 15 && d.Day <= 21))
					return d.DayOfWeek == DayOfWeek.Monday;
			}
			// 54̏jɂȂ̂ŁAU֋xȏJzB
			if (d.Year > 2007 && d.Month == 5 && d.Day == 6)
				return d.DayOfWeek >= DayOfWeek.Monday &&
					d.DayOfWeek <= DayOfWeek.Wednesday;
			// Uւx
			if (d.DayOfWeek == DayOfWeek.Monday)
				return IsHoliday(d.AddDays(-1));
			return false;
		}
	}
}
