/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue;

import java.io.Serializable;

@Deprecated
public final class RetryOptions
implements Serializable {
    static final long serialVersionUID = 3225312983180764485L;
    private Integer taskRetryLimit;
    private Long taskAgeLimitSeconds;
    private Double minBackoffSeconds;
    private Double maxBackoffSeconds;
    private Integer maxDoublings;

    private RetryOptions() {
    }

    public RetryOptions(RetryOptions options) {
        this.taskRetryLimit = options.taskRetryLimit;
        this.taskAgeLimitSeconds = options.taskAgeLimitSeconds;
        this.minBackoffSeconds = options.minBackoffSeconds;
        this.maxBackoffSeconds = options.maxBackoffSeconds;
        this.maxDoublings = options.maxDoublings;
    }

    public RetryOptions taskRetryLimit(int taskRetryLimit) {
        if (taskRetryLimit < 0) {
            throw new IllegalArgumentException("taskRetryLimit must not be negative.");
        }
        this.taskRetryLimit = taskRetryLimit;
        return this;
    }

    Integer getTaskRetryLimit() {
        return this.taskRetryLimit;
    }

    public RetryOptions taskAgeLimitSeconds(long taskAgeLimitSeconds) {
        if (taskAgeLimitSeconds < 0L) {
            throw new IllegalArgumentException("taskAgeLimitSeconds must not be negative.");
        }
        this.taskAgeLimitSeconds = taskAgeLimitSeconds;
        return this;
    }

    Long getTaskAgeLimitSeconds() {
        return this.taskAgeLimitSeconds;
    }

    public RetryOptions minBackoffSeconds(double minBackoffSeconds) {
        if (minBackoffSeconds < 0.0) {
            throw new IllegalArgumentException("minBackoffSeconds must not be negative.");
        }
        this.minBackoffSeconds = minBackoffSeconds;
        return this;
    }

    Double getMinBackoffSeconds() {
        return this.minBackoffSeconds;
    }

    public RetryOptions maxBackoffSeconds(double maxBackoffSeconds) {
        if (maxBackoffSeconds < 0.0) {
            throw new IllegalArgumentException("maxBackoffSeconds must not be negative.");
        }
        this.maxBackoffSeconds = maxBackoffSeconds;
        return this;
    }

    Double getMaxBackoffSeconds() {
        return this.maxBackoffSeconds;
    }

    public RetryOptions maxDoublings(int maxDoublings) {
        if (maxDoublings < 0) {
            throw new IllegalArgumentException("maxDoublings must not be negative.");
        }
        this.maxDoublings = maxDoublings;
        return this;
    }

    Integer getMaxDoublings() {
        return this.maxDoublings;
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + (this.taskRetryLimit == null ? 0 : this.taskRetryLimit.hashCode());
        result = 37 * result + (this.taskAgeLimitSeconds == null ? 0 : this.taskAgeLimitSeconds.hashCode());
        result = 37 * result + (this.minBackoffSeconds == null ? 0 : this.minBackoffSeconds.hashCode());
        result = 37 * result + (this.maxBackoffSeconds == null ? 0 : this.maxBackoffSeconds.hashCode());
        result = 37 * result + (this.maxDoublings == null ? 0 : this.maxDoublings.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RetryOptions other = (RetryOptions)obj;
        if (this.taskRetryLimit == null ? other.taskRetryLimit != null : !this.taskRetryLimit.equals(other.taskRetryLimit)) {
            return false;
        }
        if (this.taskAgeLimitSeconds == null ? other.taskAgeLimitSeconds != null : !this.taskAgeLimitSeconds.equals(other.taskAgeLimitSeconds)) {
            return false;
        }
        if (this.minBackoffSeconds == null ? other.minBackoffSeconds != null : !this.minBackoffSeconds.equals(other.minBackoffSeconds)) {
            return false;
        }
        if (this.maxBackoffSeconds == null ? other.maxBackoffSeconds != null : !this.maxBackoffSeconds.equals(other.maxBackoffSeconds)) {
            return false;
        }
        return !(this.maxDoublings == null ? other.maxDoublings != null : !this.maxDoublings.equals(other.maxDoublings));
    }

    public String toString() {
        return "RetryOptions[taskRetryLimit=" + this.taskRetryLimit + ", taskAgeLimitSeconds=" + this.taskAgeLimitSeconds + ", minBackoffSeconds=" + this.minBackoffSeconds + ", maxBackoffSeconds=" + this.maxBackoffSeconds + ", maxDoublings=" + this.maxDoublings + "]";
    }

    public static final class Builder {
        public static RetryOptions withTaskRetryLimit(int taskRetryLimit) {
            return Builder.withDefaults().taskRetryLimit(taskRetryLimit);
        }

        public static RetryOptions withTaskAgeLimitSeconds(long taskAgeLimitSeconds) {
            return Builder.withDefaults().taskAgeLimitSeconds(taskAgeLimitSeconds);
        }

        public static RetryOptions withMinBackoffSeconds(double minBackoffSeconds) {
            return Builder.withDefaults().minBackoffSeconds(minBackoffSeconds);
        }

        public static RetryOptions withMaxBackoffSeconds(double maxBackoffSeconds) {
            return Builder.withDefaults().maxBackoffSeconds(maxBackoffSeconds);
        }

        public static RetryOptions withMaxDoublings(int maxDoublings) {
            return Builder.withDefaults().maxDoublings(maxDoublings);
        }

        public static RetryOptions withDefaults() {
            return new RetryOptions();
        }

        private Builder() {
        }
    }
}

