/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
@GwtCompatible
public final class Optional<T> {
    private static final Optional<Object> ABSENT = new Optional<Object>(null);
    @Nullable
    private final T reference;

    public static <T> Optional<T> absent() {
        return ABSENT;
    }

    public static <T> Optional<T> of(T reference) {
        return new Optional<T>(Preconditions.checkNotNull(reference));
    }

    public static <T> Optional<T> fromNullable(@Nullable T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Optional<T>(nullableReference);
    }

    private Optional(@Nullable T reference) {
        this.reference = reference;
    }

    public boolean isPresent() {
        return this.reference != null;
    }

    public T get() {
        Preconditions.checkState(this.isPresent());
        return this.reference;
    }

    @Nullable
    public T get(@Nullable T defaultValue) {
        return this.isPresent() ? this.reference : defaultValue;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Optional) {
            Optional other = (Optional)object;
            return Objects.equal(this.reference, other.reference);
        }
        return false;
    }

    public int hashCode() {
        return 1502476572 + (this.isPresent() ? this.reference.hashCode() : 0);
    }

    public String toString() {
        return this.isPresent() ? "Optional.of(" + this.reference + ")" : "Optional.absent()";
    }
}

