/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.datastore;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.SimpleTypeVisitor;
import com.sun.mirror.util.TypeVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slim3.gen.datastore.AbstractDataType;
import org.slim3.gen.datastore.ArrayListType;
import org.slim3.gen.datastore.ArrayType;
import org.slim3.gen.datastore.BlobKeyType;
import org.slim3.gen.datastore.BlobType;
import org.slim3.gen.datastore.BooleanType;
import org.slim3.gen.datastore.CategoryType;
import org.slim3.gen.datastore.CollectionType;
import org.slim3.gen.datastore.CorePrimitiveType;
import org.slim3.gen.datastore.CoreReferenceType;
import org.slim3.gen.datastore.DataType;
import org.slim3.gen.datastore.DateType;
import org.slim3.gen.datastore.DoubleType;
import org.slim3.gen.datastore.EmailType;
import org.slim3.gen.datastore.EnumType;
import org.slim3.gen.datastore.FloatType;
import org.slim3.gen.datastore.GeoPtType;
import org.slim3.gen.datastore.HashSetType;
import org.slim3.gen.datastore.IMHandleType;
import org.slim3.gen.datastore.IntegerType;
import org.slim3.gen.datastore.InverseModelListRefType;
import org.slim3.gen.datastore.InverseModelRefType;
import org.slim3.gen.datastore.KeyType;
import org.slim3.gen.datastore.LinkType;
import org.slim3.gen.datastore.LinkedHashSetType;
import org.slim3.gen.datastore.LinkedListType;
import org.slim3.gen.datastore.ListType;
import org.slim3.gen.datastore.LongType;
import org.slim3.gen.datastore.ModelRefType;
import org.slim3.gen.datastore.OtherReferenceType;
import org.slim3.gen.datastore.PhoneNumberType;
import org.slim3.gen.datastore.PostalAddressType;
import org.slim3.gen.datastore.PrimitiveBooleanType;
import org.slim3.gen.datastore.PrimitiveByteType;
import org.slim3.gen.datastore.PrimitiveDoubleType;
import org.slim3.gen.datastore.PrimitiveFloatType;
import org.slim3.gen.datastore.PrimitiveIntType;
import org.slim3.gen.datastore.PrimitiveLongType;
import org.slim3.gen.datastore.PrimitiveShortType;
import org.slim3.gen.datastore.RatingType;
import org.slim3.gen.datastore.SetType;
import org.slim3.gen.datastore.ShortBlobType;
import org.slim3.gen.datastore.ShortType;
import org.slim3.gen.datastore.SortedSetType;
import org.slim3.gen.datastore.StringType;
import org.slim3.gen.datastore.TextType;
import org.slim3.gen.datastore.TreeSetType;
import org.slim3.gen.datastore.UserType;
import org.slim3.gen.message.MessageCode;
import org.slim3.gen.processor.UnknownDeclarationException;
import org.slim3.gen.processor.ValidationException;
import org.slim3.gen.util.TypeUtil;

public class DataTypeFactory {
    protected static final Map<PrimitiveType.Kind, CorePrimitiveType> CORE_PRIMITIVE_TYPES = new HashMap<PrimitiveType.Kind, CorePrimitiveType>();
    protected static final Map<String, CoreReferenceType> CORE_REFERENCE_TYPES;
    protected final AnnotationProcessorEnvironment env;

    public DataTypeFactory(AnnotationProcessorEnvironment env) {
        this.env = env;
    }

    public DataType createDataType(Declaration declaration, TypeMirror typeMirror) {
        if (declaration == null) {
            throw new NullPointerException("The declaration parameter is null.");
        }
        if (typeMirror == null) {
            throw new NullPointerException("The typeMirror parameter is null.");
        }
        return this.createDataTypeInternal(declaration, typeMirror);
    }

    protected DataType createDataTypeInternal(Declaration declaration, TypeMirror typeMirror) {
        Builder builder = new Builder(declaration, typeMirror);
        return builder.build();
    }

    static {
        CORE_PRIMITIVE_TYPES.put(PrimitiveType.Kind.BOOLEAN, new PrimitiveBooleanType());
        CORE_PRIMITIVE_TYPES.put(PrimitiveType.Kind.SHORT, new PrimitiveShortType());
        CORE_PRIMITIVE_TYPES.put(PrimitiveType.Kind.INT, new PrimitiveIntType());
        CORE_PRIMITIVE_TYPES.put(PrimitiveType.Kind.LONG, new PrimitiveLongType());
        CORE_PRIMITIVE_TYPES.put(PrimitiveType.Kind.FLOAT, new PrimitiveFloatType());
        CORE_PRIMITIVE_TYPES.put(PrimitiveType.Kind.DOUBLE, new PrimitiveDoubleType());
        CORE_REFERENCE_TYPES = new HashMap<String, CoreReferenceType>();
        CORE_REFERENCE_TYPES.put("java.lang.String", new StringType());
        CORE_REFERENCE_TYPES.put("java.lang.Boolean", new BooleanType());
        CORE_REFERENCE_TYPES.put("java.lang.Short", new ShortType());
        CORE_REFERENCE_TYPES.put("java.lang.Integer", new IntegerType());
        CORE_REFERENCE_TYPES.put("java.lang.Long", new LongType());
        CORE_REFERENCE_TYPES.put("java.lang.Float", new FloatType());
        CORE_REFERENCE_TYPES.put("java.lang.Double", new DoubleType());
        CORE_REFERENCE_TYPES.put("java.util.Date", new DateType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.users.User", new UserType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.datastore.Key", new KeyType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.datastore.Category", new CategoryType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.datastore.Email", new EmailType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.datastore.GeoPt", new GeoPtType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.datastore.IMHandle", new IMHandleType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.datastore.Link", new LinkType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.datastore.PhoneNumber", new PhoneNumberType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.datastore.PostalAddress", new PostalAddressType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.datastore.Rating", new RatingType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.datastore.ShortBlob", new ShortBlobType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.datastore.Blob", new BlobType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.datastore.Text", new TextType());
        CORE_REFERENCE_TYPES.put("com.google.appengine.api.blobstore.BlobKey", new BlobKeyType());
    }

    protected class Builder
    extends SimpleTypeVisitor {
        protected final Declaration declaration;
        protected final TypeMirror typeMirror;
        protected AbstractDataType dataType;

        public Builder(Declaration declaration, TypeMirror typeMirror) {
            this.declaration = declaration;
            this.typeMirror = typeMirror;
        }

        public DataType build() {
            this.typeMirror.accept((TypeVisitor)this);
            return this.dataType;
        }

        public void visitArrayType(final com.sun.mirror.type.ArrayType arrayType) {
            TypeMirror componentType = arrayType.getComponentType();
            componentType.accept((TypeVisitor)new SimpleTypeVisitor(){

                public void visitPrimitiveType(PrimitiveType primitiveType) {
                    PrimitiveType.Kind kind = primitiveType.getKind();
                    if (kind == PrimitiveType.Kind.BYTE) {
                        Builder.this.dataType = new ArrayType("byte[]", arrayType.toString(), new PrimitiveByteType());
                        return;
                    }
                    super.visitPrimitiveType(primitiveType);
                }

                public void visitTypeMirror(TypeMirror typemirror) {
                    Builder.this.dataType = new ArrayType(Builder.this.typeMirror.toString(), arrayType.toString(), new OtherReferenceType(Builder.this.typeMirror.toString(), Builder.this.typeMirror.toString()));
                }
            });
        }

        public void visitDeclaredType(DeclaredType declaredType) {
            TypeDeclaration typeDeclaration = this.toTypeDeclaration(declaredType);
            String className = typeDeclaration.getQualifiedName();
            this.dataType = this.getCoreReferenceType(className, declaredType);
            if (this.dataType != null) {
                return;
            }
            this.dataType = this.getModelRefType(className, declaredType);
            if (this.dataType != null) {
                return;
            }
            this.dataType = this.getInverseModelRefType(className, declaredType);
            if (this.dataType != null) {
                return;
            }
            this.dataType = this.getInverseModelListRefType(className, declaredType);
            if (this.dataType != null) {
                return;
            }
            this.dataType = this.getCollectionType(className, declaredType);
            if (this.dataType != null) {
                return;
            }
            this.dataType = new OtherReferenceType(className, declaredType.toString());
        }

        public void visitPrimitiveType(PrimitiveType primitiveType) {
            PrimitiveType.Kind kind = primitiveType.getKind();
            this.dataType = this.getCorePrimitiveType(kind);
            if (this.dataType != null) {
                return;
            }
            throw new ValidationException(MessageCode.SLIM3GEN1002, DataTypeFactory.this.env, this.declaration.getPosition(), kind.name().toLowerCase());
        }

        public void visitTypeMirror(TypeMirror typeMirror) {
            throw new AssertionError((Object)"unreachable");
        }

        protected TypeDeclaration toTypeDeclaration(DeclaredType declaredType) {
            TypeDeclaration typeDeclaration = declaredType.getDeclaration();
            if (typeDeclaration != null) {
                return typeDeclaration;
            }
            throw new UnknownDeclarationException(DataTypeFactory.this.env, this.declaration, (TypeMirror)declaredType);
        }

        protected CoreReferenceType getCoreReferenceType(final String className, DeclaredType declaredType) {
            if (CORE_REFERENCE_TYPES.containsKey(className)) {
                return CORE_REFERENCE_TYPES.get(className);
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Visitor
            extends SimpleTypeVisitor {
                CoreReferenceType result;

                Visitor() {
                }

                public void visitEnumType(com.sun.mirror.type.EnumType enumType) {
                    this.result = new EnumType(className);
                }
            }
            Visitor visitor = new Visitor();
            declaredType.accept((TypeVisitor)visitor);
            return visitor.result;
        }

        protected ModelRefType getModelRefType(String className, DeclaredType declaredType) {
            DeclaredType referenceModelType = this.getReferenceModelType(className, declaredType, "org.slim3.datastore.ModelRef");
            if (referenceModelType == null) {
                return null;
            }
            TypeDeclaration referenceModelDeclaration = this.toTypeDeclaration(referenceModelType);
            return new ModelRefType(className, declaredType.toString(), referenceModelDeclaration.getQualifiedName(), referenceModelType.toString());
        }

        protected InverseModelRefType getInverseModelRefType(String className, DeclaredType declaredType) {
            DeclaredType referenceModelType = this.getReferenceModelType(className, declaredType, "org.slim3.datastore.InverseModelRef");
            if (referenceModelType == null) {
                return null;
            }
            TypeDeclaration referenceModelDeclaration = this.toTypeDeclaration(referenceModelType);
            return new InverseModelRefType(className, declaredType.toString(), referenceModelDeclaration.getQualifiedName(), referenceModelType.toString());
        }

        protected InverseModelListRefType getInverseModelListRefType(String className, DeclaredType declaredType) {
            DeclaredType referenceModelType = this.getReferenceModelType(className, declaredType, "org.slim3.datastore.InverseModelListRef");
            if (referenceModelType == null) {
                return null;
            }
            TypeDeclaration referenceModelDeclaration = this.toTypeDeclaration(referenceModelType);
            return new InverseModelListRefType(className, declaredType.toString(), referenceModelDeclaration.getQualifiedName(), referenceModelType.toString());
        }

        protected DeclaredType getReferenceModelType(String className, DeclaredType declaredType, String superclassName) {
            DeclaredType supertype = TypeUtil.getSuperDeclaredType(DataTypeFactory.this.env, (TypeMirror)declaredType, superclassName);
            if (supertype == null || supertype.getActualTypeArguments().isEmpty()) {
                return null;
            }
            return TypeUtil.toDeclaredType((TypeMirror)supertype.getActualTypeArguments().iterator().next());
        }

        protected CorePrimitiveType getCorePrimitiveType(PrimitiveType.Kind kind) {
            return CORE_PRIMITIVE_TYPES.get(kind);
        }

        protected CollectionType getCollectionType(String className, DeclaredType declaredType) {
            if (!TypeUtil.isSubtype(DataTypeFactory.this.env, (TypeMirror)declaredType, Collection.class)) {
                return null;
            }
            Collection typeArgs = declaredType.getActualTypeArguments();
            if (typeArgs.isEmpty()) {
                throw new ValidationException(MessageCode.SLIM3GEN1004, DataTypeFactory.this.env, this.declaration.getPosition(), declaredType);
            }
            TypeMirror elementType = (TypeMirror)typeArgs.iterator().next();
            DeclaredType elementDeclaredType = TypeUtil.toDeclaredType(elementType);
            if (elementDeclaredType == null) {
                throw new ValidationException(MessageCode.SLIM3GEN1016, DataTypeFactory.this.env, this.declaration.getPosition(), elementType);
            }
            TypeDeclaration elementDeclaration = this.toTypeDeclaration(elementDeclaredType);
            CoreReferenceType elementCoreReferenceType = this.getCoreReferenceType(elementDeclaration.getQualifiedName(), elementDeclaredType);
            if (elementCoreReferenceType != null) {
                return this.createCollectionType(className, declaredType, elementCoreReferenceType);
            }
            DataType elementDataType = DataTypeFactory.this.createDataTypeInternal((Declaration)elementDeclaration, elementType);
            CollectionType collectionType = this.createCollectionType(className, declaredType, elementDataType);
            return collectionType;
        }

        protected CollectionType createCollectionType(String className, DeclaredType declaredType, DataType elementType) {
            String typeName = declaredType.toString();
            if ("java.util.List".equals(className)) {
                return new ListType(className, typeName, elementType);
            }
            if ("java.util.ArrayList".equals(className)) {
                return new ArrayListType(className, typeName, elementType);
            }
            if ("java.util.LinkedList".equals(className)) {
                return new LinkedListType(className, typeName, elementType);
            }
            if ("java.util.Set".equals(className)) {
                return new SetType(className, typeName, elementType);
            }
            if ("java.util.HashSet".equals(className)) {
                return new HashSetType(className, typeName, elementType);
            }
            if ("java.util.LinkedHashSet".equals(className)) {
                return new LinkedHashSetType(className, typeName, elementType);
            }
            if ("java.util.SortedSet".equals(className)) {
                return new SortedSetType(className, typeName, elementType);
            }
            if ("java.util.TreeSet".equals(className)) {
                return new TreeSetType(className, typeName, elementType);
            }
            throw new ValidationException(MessageCode.SLIM3GEN1002, DataTypeFactory.this.env, this.declaration.getPosition(), className);
        }
    }
}

