/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.task;

import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.slim3.gen.desc.GWTServiceImplDesc;
import org.slim3.gen.generator.GWTServiceImplGenerator;
import org.slim3.gen.generator.GWTServiceImplTestCaseGenerator;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.task.AbstractGenJavaFileTask;
import org.slim3.gen.task.ClassNameBuilder;
import org.slim3.gen.task.JavaFile;
import org.slim3.gen.task.WebConfig;

public class GenGWTServiceImplTask
extends AbstractGenJavaFileTask {
    protected String packageName;
    protected String superclassName = "java.lang.Object";
    protected String testCaseSuperclassName = "org.slim3.tester.ServletTestCase";
    protected String serviceClassName;
    protected String serviceDefinition;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setSuperclassName(String superclassName) {
        this.superclassName = superclassName;
    }

    public void setTestCaseSuperclassName(String testCaseSuperclassName) {
        this.testCaseSuperclassName = testCaseSuperclassName;
    }

    public void setServiceClassName(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    public void setServiceDefinition(String serviceDefinition) {
        this.serviceDefinition = serviceDefinition;
    }

    public void doExecute() throws Exception {
        super.doExecute();
        if (this.serviceClassName == null) {
            throw new IllegalStateException("The serviceClassName parameter is null.");
        }
        GWTServiceImplDesc serviceImplDesc = this.createServiceImplDesc();
        JavaFile javaFile = this.createJavaFile(serviceImplDesc);
        Generator generator = this.createServiceImplGenerator(serviceImplDesc);
        this.generateJavaFile(generator, javaFile);
        JavaFile testCaseJavaFile = this.createTestCaseJavaFile(serviceImplDesc);
        Generator testCaseGenerator = this.createServiceImplTestCaseGenerator(serviceImplDesc);
        this.generateJavaFile(testCaseGenerator, testCaseJavaFile);
    }

    private GWTServiceImplDesc createServiceImplDesc() throws IOException, XPathExpressionException {
        ClassNameBuilder nameBuilder = new ClassNameBuilder();
        nameBuilder.append(this.getServiceImplBasePackageName());
        nameBuilder.append(this.serviceDefinition);
        nameBuilder.appendSuffix("Impl");
        GWTServiceImplDesc serviceImplDesc = new GWTServiceImplDesc();
        serviceImplDesc.setPackageName(nameBuilder.getPackageName());
        serviceImplDesc.setSimpleName(nameBuilder.getSimpleName());
        serviceImplDesc.setSuperclassName(this.superclassName);
        serviceImplDesc.setTestCaseSuperclassName(this.testCaseSuperclassName);
        serviceImplDesc.setServiceClassName(this.serviceClassName);
        return serviceImplDesc;
    }

    protected String getServiceImplBasePackageName() throws IOException, XPathExpressionException {
        if (this.packageName != null) {
            return this.packageName;
        }
        WebConfig config = this.createWebConfig();
        StringBuilder buf = new StringBuilder();
        buf.append(config.getRootPackageName());
        buf.append(".");
        buf.append("server");
        buf.append(".");
        buf.append("service");
        return buf.toString();
    }

    protected Generator createServiceImplGenerator(GWTServiceImplDesc serviceImplDesc) {
        return new GWTServiceImplGenerator(serviceImplDesc);
    }

    protected Generator createServiceImplTestCaseGenerator(GWTServiceImplDesc serviceImplDesc) {
        return new GWTServiceImplTestCaseGenerator(serviceImplDesc);
    }
}

