/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.cloud.sql.jdbc.internal.ConnectionProperty;
import com.google.cloud.sql.jdbc.internal.Util;
import java.sql.DriverPropertyInfo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Url {
    public static final String DEFAULT_PREFIX = "jdbc:google:rdbms:";
    public static final String[] URL_PREFIXES = new String[]{"jdbc:google:rdbms:", "jdbc:google:speckle:"};
    private static final Set<String> LOCAL_PROPERTIES = Collections.unmodifiableSet(Util.newHashSet((Comparable[])new String[]{ConnectionProperty.OAUTH2_REFRESH_TOKEN.key(), ConnectionProperty.OAUTH2_ACCESS_TOKEN.key(), ConnectionProperty.OAUTH2_AUTH_URL.key(), ConnectionProperty.OAUTH2_TOKEN_URL.key(), ConnectionProperty.OAUTH2_CLIENT_ID.key(), ConnectionProperty.OAUTH2_CLIENT_SECRET.key()}));
    protected final String originalUrl;
    protected final Properties originalInfo;
    protected final Map<String, String> properties;
    protected final Map<String, String> localProperties;

    public static Url create(String url, Properties info) {
        if (!Url.acceptsUrl(url)) {
            throw new IllegalArgumentException(MessageFormat.format("URL is not in the correct format: {0}", url));
        }
        HashMap<String, String> properties = Util.newHashMap();
        String rest = Url.stripProtocol(url);
        int index = rest.indexOf(63);
        if (index != -1) {
            Url.parseProperties(rest.substring(index + 1), properties);
            rest = rest.substring(0, index);
        }
        if ((index = rest.indexOf(35)) != -1) {
            Url.parseInstanceDatabase(rest.substring(index + 1), properties);
            rest = rest.substring(0, index);
            if (rest.startsWith("//")) {
                rest = rest.substring("//".length());
            }
            Url.parseServer(rest, properties);
        } else {
            if (rest.startsWith("//")) {
                rest = rest.substring("//".length());
            }
            Url.parseInstanceDatabase(rest.substring(index + 1), properties);
        }
        if (info == null) {
            info = new Properties();
        }
        HashMap<String, String> localProperties = Util.newHashMap();
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            if (LOCAL_PROPERTIES.contains(entry.getKey())) {
                localProperties.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                continue;
            }
            properties.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        if (!properties.containsKey(ConnectionProperty.INSTANCE.key())) {
            throw new IllegalArgumentException(MessageFormat.format("URL is not in the correct format: {0}", url));
        }
        return new Url(url, info, properties, localProperties);
    }

    public static Url createFromMap(String url, Map<String, String> properties) {
        Properties info = new Properties();
        for (Map.Entry<String, String> e : properties.entrySet()) {
            info.put(e.getKey(), e.getValue());
        }
        return Url.create(url, info);
    }

    public static boolean acceptsUrl(String url) {
        if (url == null) {
            return false;
        }
        for (String prefix : URL_PREFIXES) {
            if (!url.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static String stripProtocol(String url) {
        for (String prefix : URL_PREFIXES) {
            if (!url.startsWith(prefix)) continue;
            return url.substring(prefix.length());
        }
        throw new IllegalArgumentException(url + " does not start with a valid protocol.");
    }

    private static void parseServer(String s, Map<String, String> properties) {
        properties.put(ConnectionProperty.SERVER.key(), s);
    }

    private static void parseInstanceDatabase(String s, Map<String, String> properties) {
        int index = s.indexOf(47);
        if (index != -1) {
            String[] parts = s.split("\\/");
            Url.putIfNotEmpty(properties, ConnectionProperty.INSTANCE, parts[0]);
            Url.putIfNotEmpty(properties, ConnectionProperty.DATABASE, parts[1]);
        } else {
            Url.putIfNotEmpty(properties, ConnectionProperty.INSTANCE, s);
        }
    }

    private static void putIfNotEmpty(Map<String, String> properties, ConnectionProperty property, String value) {
        if (!Util.isEmpty(value)) {
            Url.put(properties, property, value);
        }
    }

    private static void put(Map<String, String> properties, ConnectionProperty property, String value) {
        properties.put(property.key(), value);
    }

    private static void parseProperties(String s, Map<String, String> properties) {
        String[] parts;
        for (String part : parts = s.split("\\&")) {
            String[] kv = part.split("\\=");
            properties.put(kv[0], kv[1]);
        }
    }

    private Url(String originalUrl, Properties info, Map<String, String> properties, Map<String, String> localProperties) {
        this.originalUrl = originalUrl;
        this.originalInfo = info;
        this.properties = Collections.unmodifiableMap(properties);
        this.localProperties = localProperties;
    }

    protected Url(Url url) {
        this(url.originalUrl, url.originalInfo, url.properties, url.localProperties);
    }

    public String getInstance() {
        return this.getProperty(ConnectionProperty.INSTANCE);
    }

    public String getServer() {
        return this.getProperty(ConnectionProperty.SERVER);
    }

    public String getDatabase() {
        return this.getProperty(ConnectionProperty.DATABASE);
    }

    public String getUser() {
        return this.getProperty(ConnectionProperty.USER);
    }

    public String getPassword() {
        return this.getProperty(ConnectionProperty.PASSWORD);
    }

    public Integer getConnectTimeoutSeconds() {
        return this.getInteger(ConnectionProperty.CONNECT_TIMEOUT_SECONDS);
    }

    public Integer getQueryTimeoutSeconds() {
        return this.getInteger(ConnectionProperty.QUERY_TIMEOUT_SECONDS);
    }

    public String getOAuth2RefreshToken() {
        return this.getLocalProperty(ConnectionProperty.OAUTH2_REFRESH_TOKEN);
    }

    public String getOAuth2AccessToken() {
        return this.getLocalProperty(ConnectionProperty.OAUTH2_ACCESS_TOKEN);
    }

    public String getOAuth2AuthUrl() {
        return this.getLocalProperty(ConnectionProperty.OAUTH2_AUTH_URL);
    }

    public String getOAuth2TokenUrl() {
        return this.getLocalProperty(ConnectionProperty.OAUTH2_TOKEN_URL);
    }

    public String getOAuth2ClientId() {
        return this.getLocalProperty(ConnectionProperty.OAUTH2_CLIENT_ID);
    }

    public String getOAuth2ClientSecret() {
        return this.getLocalProperty(ConnectionProperty.OAUTH2_CLIENT_SECRET);
    }

    public String getGoogleApiParameters() {
        return this.getProperty(ConnectionProperty.GOOGLEAPI_PARAMS);
    }

    Integer getInteger(ConnectionProperty property) {
        return this.getInteger(property.key());
    }

    Integer getInteger(String key) {
        String value = this.properties.get(key);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    String getProperty(String key) {
        return this.properties.get(key);
    }

    private String getProperty(ConnectionProperty property) {
        String value = this.properties.get(property.key());
        return value != null ? value : property.defaultValue();
    }

    private String getLocalProperty(ConnectionProperty property) {
        String value = this.localProperties.get(property.key());
        return value != null ? value : property.defaultValue();
    }

    boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean hasLocalProperty(String key) {
        return this.localProperties.containsKey(key);
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public Properties getOriginalInfo() {
        return this.originalInfo;
    }

    public DriverPropertyInfo[] getDriverPropertyInfos() {
        Map<String, DriverPropertyInfo> defaults = this.keyDriverPropertyInfoMap(ConnectionProperty.getDefaults());
        ArrayList<DriverPropertyInfo> pis = Util.newArrayList();
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            if (!defaults.containsKey(e.getKey())) continue;
            pis.add(this.newDriverPropertyInfo(defaults.get(e.getKey()), e.getValue()));
        }
        return pis.toArray(new DriverPropertyInfo[pis.size()]);
    }

    private Map<String, DriverPropertyInfo> keyDriverPropertyInfoMap(Set<ConnectionProperty> cps) {
        HashMap<String, DriverPropertyInfo> map = Util.newHashMap();
        for (ConnectionProperty cp : cps) {
            map.put(cp.key(), cp.info());
        }
        return map;
    }

    private DriverPropertyInfo newDriverPropertyInfo(DriverPropertyInfo original, String value) {
        DriverPropertyInfo dpi = ConnectionProperty.newDriverPropertyInfo(original.name, value, original.description, original.choices);
        dpi.required = original.required;
        return dpi;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Url)) {
            return false;
        }
        Url that = (Url)obj;
        return ((Object)this.properties).equals(that.properties);
    }

    public int hashCode() {
        return ((Object)this.properties).hashCode();
    }

    public String toString() {
        return this.properties.toString();
    }
}

