/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.sql.jdbc.internal.AbstractSqlClient;
import com.google.cloud.sql.jdbc.internal.BoundValue;
import com.google.cloud.sql.jdbc.internal.SqlRpc;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.CloseConnectionRequest;
import com.google.protos.cloud.sql.CloseConnectionResponse;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.MetadataResponse;
import com.google.protos.cloud.sql.OpenConnectionRequest;
import com.google.protos.cloud.sql.OpenConnectionResponse;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlProtoClient
extends AbstractSqlClient {
    private static final Logger LOG = Logger.getLogger(SqlProtoClient.class.getName());
    private final SqlRpc rpc;

    public SqlProtoClient(String instance, SqlRpc stub) {
        super(instance);
        this.rpc = Util.checkNotNull(stub, "stub can not be null");
        LOG.log(Level.FINE, "Created client for instance: {0}", instance);
    }

    @Override
    public OpenConnectionResponse openConnection(SqlRpcOptions options, Url url) throws SQLException {
        LOG.log(Level.FINE, "Executing Connect: {0} at {1}/{2}", new Object[]{url.getUser(), url.getInstance(), url.getDatabase()});
        OpenConnectionRequest request = this.createConnectRequest(url);
        OpenConnectionResponse response = this.rpc.openConnection(options, request);
        LOG.log(Level.FINEST, "Stubby response: {0}", response);
        return response;
    }

    @Override
    public CloseConnectionResponse closeConnection(SqlRpcOptions options, ByteString connectionId) throws SQLException {
        LOG.log(Level.FINE, "Executing Release: {0}", connectionId);
        CloseConnectionRequest request = this.createReleaseRequest(connectionId);
        CloseConnectionResponse response = this.rpc.closeConnection(options, request);
        LOG.log(Level.FINEST, "Stubby response: {0}", response);
        return response;
    }

    @Override
    public ExecResponse executeSql(SqlRpcOptions options, ByteString connectionId, String sql) throws SQLException {
        return this.executeSql(options, connectionId, sql, Collections.<BoundValue>emptyList());
    }

    @Override
    public ExecResponse executeSql(SqlRpcOptions options, ByteString connectionId, String sql, List<BoundValue> bindParameters) throws SQLException {
        LOG.log(Level.FINE, "Executing SQL: {0}", sql);
        ExecRequest request = this.createExecRequest(options, connectionId, sql, bindParameters);
        ExecResponse response = this.rpc.exec(options, request);
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return response;
    }

    @Override
    public ExecResponse executeBatchSql(SqlRpcOptions options, ByteString connectionId, String sql, List<List<BoundValue>> batchBindParameters) throws SQLException {
        LOG.log(Level.FINE, "Executing SQL: {0}", sql);
        ExecRequest request = this.createBatchExecRequest(options, connectionId, sql, batchBindParameters);
        ExecResponse response = this.rpc.exec(options, request);
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return response;
    }

    @Override
    public ExecResponse executeBatchSql(SqlRpcOptions options, ByteString connectionId, List<String> batchSql) throws SQLException {
        LOG.log(Level.FINE, "Executing SQL: {0}", batchSql);
        ExecRequest request = this.createBatchExecRequest(options, connectionId, batchSql);
        ExecResponse response = this.rpc.exec(options, request);
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return response;
    }

    @Override
    public ExecResponse executeNext(SqlRpcOptions options, ByteString connectionId, long statementId) throws SQLException {
        LOG.log(Level.FINE, "Executing SQL: {0}", statementId);
        ExecRequest request = this.createExecNextRequest(options, connectionId, statementId);
        ExecResponse response = this.rpc.exec(options, request);
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return response;
    }

    @Override
    public ExecOpResponse executeOperation(SqlRpcOptions options, ByteString connectionId, Client.OpProto op) throws SQLException {
        LOG.log(Level.FINE, "Executing Operation: {0}", op.getType().name());
        ExecOpRequest request = this.createExecOpRequest(connectionId, op);
        ExecOpResponse response = this.rpc.execOp(options, request);
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return response;
    }

    @Override
    public final MetadataResponse getMetadata(SqlRpcOptions options, ByteString connectionId, Client.MetadataType metadataType, List<BoundValue> bindParameters) throws SQLException {
        LOG.log(Level.FINE, "Executing metadata request for type: {0}", metadataType);
        MetadataRequest request = this.createMetadataRequest(connectionId, metadataType, bindParameters);
        MetadataResponse response = this.rpc.getMetadata(options, request);
        LOG.log(Level.FINEST, "Stubby response: {0}", response);
        return response;
    }

    @Override
    public SqlRpc getRpc() {
        return this.rpc;
    }
}

