/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.cloud.sql.jdbc.internal.SQLFeatureNotYetImplementedException;
import com.google.protos.cloud.sql.Client;
import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Exceptions {
    public static final String BAD_URL_FORMAT = "URL is not in the correct format: {0}";
    public static final String INVALID_PARAMETER = "Invalid parameter for {0} value {1}.";
    public static final String INVALID_PARAMETER_FOR_TYPE = "Invalid parameter for {0} type {1}.";
    public static final String INVALID_PARAMETER_MESSAGE = "Invalid parameter for {0} value {1}. {2}";

    private Exceptions() {
    }

    public static SQLException newConnectionClosedException() {
        return new SQLException("This Connection is closed.");
    }

    public static SQLException newResultSetClosedException() {
        return new SQLException("This ResultSet is closed.");
    }

    public static SQLException newStatementClosedException() {
        return new SQLException("This Statement is closed.");
    }

    public static SQLClientInfoException newClientInfoConnectionClosedException() {
        return new SQLClientInfoException("This connection is Closed", Collections.<String, ClientInfoStatus>emptyMap());
    }

    public static SQLClientInfoException newClientInfoNotSupportedException() {
        return new SQLClientInfoException("ClientInfo is not supported.", Collections.<String, ClientInfoStatus>emptyMap());
    }

    public static SQLException newStatementExecuteQueryNullResultSetException() {
        return new SQLException("The ResultSet can not be null for Statement.executeQuery.");
    }

    public static SQLException newStatementExecuteUpdateWithResultSetException() {
        return new SQLException("The ResultSet must be be null for Statement.executeUpdate.");
    }

    public static SQLException newDriverCanNotConnectException() {
        return new SQLException("Unable to connect to server.", "08001");
    }

    public static SQLException newErrorFetchingMetadataException() {
        return new SQLException("Error fetching metadata.");
    }

    public static final SQLFeatureNotYetImplementedException newNotYetImplementedException() {
        return Exceptions.newNotYetImplementedException("This feature is not implemented yet.");
    }

    public static final SQLFeatureNotYetImplementedException newNotYetImplementedException(String message) {
        return new SQLFeatureNotYetImplementedException(message);
    }

    public static SQLException resultSetDoesNotHaveColumn(Object nameOrNumber) {
        return new SQLException("ResultSet does not have a column " + nameOrNumber);
    }

    public static SQLException driverUrlNotInCorrectFormat(String url) {
        return new SQLException(MessageFormat.format(BAD_URL_FORMAT, url), "08006");
    }

    public static SQLException newInvalidParameterException(String fieldName, Object value) {
        return new SQLException(MessageFormat.format(INVALID_PARAMETER, fieldName, value), "22023");
    }

    public static SQLException newInvalidParameterException(String methodName, Class<?> clazz) {
        return new SQLException(MessageFormat.format(INVALID_PARAMETER_FOR_TYPE, methodName, clazz.getCanonicalName()), "22023");
    }

    public static SQLException newInvalidParameterException(String fieldName, Object value, String message) {
        return new SQLException(MessageFormat.format(INVALID_PARAMETER_MESSAGE, fieldName, value, message), "22023");
    }

    public static SQLException newInvalidParameterException(String message) {
        return new SQLException(message, "22023");
    }

    public static SQLException newSqlException(String message) {
        return new SQLException(message);
    }

    public static SQLException newSqlException(String message, Throwable cause) {
        return new SQLException(message + ": " + cause.getMessage());
    }

    public static SQLException newSqlException(Client.SqlException e) {
        if (e.getCode() == 1030) {
            return Exceptions.newNotYetImplementedException(e.getMessage());
        }
        return new SQLException(e.getMessage(), e.hasSqlState() ? e.getSqlState() : null, e.getCode());
    }

    public static SQLException newNotSupportedOnForwardOnlyException() {
        return new SQLException("This method is not allowed on a forward only resultset.", "0A000");
    }

    public static SQLException newNamedParameterNotYetImplementedException() {
        return Exceptions.newNotYetImplementedException("Only positional parameter is supported.");
    }
}

