/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.preference;

import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.ColorManager;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.MultiPagePropertiesEditor;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesEditor;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.resources.Messages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;

public class PropertiesEditorPreference
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_COMMENT_COLOR = "commentColor";
    public static final String P_SEPARATOR_COLOR = "separatorColor";
    public static final String P_KEY_COLOR = "keyColor";
    public static final String P_VALUE_COLOR = "valueColor";
    public static final String P_BACKGROUND_COLOR = "backgroundColor";
    public static final String P_COLLAPSE = "collapse";
    public static final String P_INIT_COLLAPSE = "initialCollapse";
    private ColorFieldEditor commentColorFieldEditor;
    private ColorFieldEditor separatorColorFieldEditor;
    private ColorFieldEditor keyColorFieldEditor;
    private ColorFieldEditor valueColorFieldEditor;
    private ColorFieldEditor backgroundColorFieldEditor;
    private BooleanFieldEditor collapseCheckFieldEditor;
    private BooleanFieldEditor initialCollapseCheckFieldEditor;

    public PropertiesEditorPreference() {
        super(1);
        this.setPreferenceStore(PropertiesEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("eclipse.propertieseditor.preference.page.title"));
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        final Group collapseGroup = new Group(parent, 0);
        GridData collapseGd = new GridData(768);
        collapseGd.horizontalSpan = 2;
        collapseGroup.setLayoutData((Object)collapseGd);
        collapseGroup.setLayout((Layout)new GridLayout(1, true));
        collapseGroup.setText(Messages.getString("eclipse.propertieseditor.preference.collapse.group"));
        this.collapseCheckFieldEditor = new BooleanFieldEditor(P_COLLAPSE, Messages.getString("eclipse.propertieseditor.preference.collapse"), (Composite)collapseGroup){

            public void valueChanged(boolean oldValue, boolean newValue) {
                PropertiesEditorPreference.this.initialCollapseCheckFieldEditor.setEnabled(newValue, (Composite)collapseGroup);
                super.valueChanged(oldValue, newValue);
            }
        };
        this.initialCollapseCheckFieldEditor = new BooleanFieldEditor(P_INIT_COLLAPSE, Messages.getString("eclipse.propertieseditor.preference.initcollapse"), (Composite)collapseGroup);
        this.initialCollapseCheckFieldEditor.setEnabled(PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean(P_COLLAPSE), (Composite)collapseGroup);
        Group colorGroup = new Group(parent, 0);
        GridData colorGd = new GridData(768);
        colorGd.horizontalSpan = 2;
        colorGroup.setLayoutData((Object)colorGd);
        colorGroup.setLayout((Layout)new GridLayout(1, true));
        colorGroup.setText(Messages.getString("eclipse.propertieseditor.preference.color.option.group"));
        this.commentColorFieldEditor = new ColorFieldEditor(P_COMMENT_COLOR, Messages.getString("eclipse.propertieseditor.preference.color.comment"), (Composite)colorGroup);
        this.separatorColorFieldEditor = new ColorFieldEditor(P_SEPARATOR_COLOR, Messages.getString("eclipse.propertieseditor.preference.color.separator"), (Composite)colorGroup);
        this.keyColorFieldEditor = new ColorFieldEditor(P_KEY_COLOR, Messages.getString("eclipse.propertieseditor.preference.color.key"), (Composite)colorGroup);
        this.valueColorFieldEditor = new ColorFieldEditor(P_VALUE_COLOR, Messages.getString("eclipse.propertieseditor.preference.color.value"), (Composite)colorGroup);
        this.backgroundColorFieldEditor = new ColorFieldEditor(P_BACKGROUND_COLOR, Messages.getString("eclipse.propertieseditor.preference.color.background"), (Composite)colorGroup);
        this.addField((FieldEditor)this.collapseCheckFieldEditor);
        this.addField((FieldEditor)this.initialCollapseCheckFieldEditor);
        this.addField((FieldEditor)this.commentColorFieldEditor);
        this.addField((FieldEditor)this.separatorColorFieldEditor);
        this.addField((FieldEditor)this.keyColorFieldEditor);
        this.addField((FieldEditor)this.valueColorFieldEditor);
        this.addField((FieldEditor)this.backgroundColorFieldEditor);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        super.performApply();
        this.apply2Editor();
    }

    private void apply2Editor() {
        IPreferenceStore pStore = this.getPreferenceStore();
        IWorkbenchWindow[] workbenchWindow = PropertiesEditorPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < workbenchWindow.length) {
            IWorkbenchPage[] workbenchPage = workbenchWindow[i].getPages();
            int j = 0;
            while (j < workbenchPage.length) {
                IEditorReference[] editorReferences = workbenchPage[j].getEditorReferences();
                int k = 0;
                while (k < editorReferences.length) {
                    PropertiesEditor editor;
                    Color color;
                    RGB rgb;
                    IEditorReference ref = editorReferences[k];
                    IEditorPart editorPart = ref.getEditor(false);
                    if (editorPart instanceof MultiPagePropertiesEditor) {
                        rgb = PreferenceConverter.getColor((IPreferenceStore)pStore, (String)P_BACKGROUND_COLOR);
                        color = new ColorManager().getColor(rgb);
                        editor = ((MultiPagePropertiesEditor)editorPart).getEditor();
                        editor.setBackground(color);
                    } else if (editorPart instanceof PropertiesEditor) {
                        rgb = PreferenceConverter.getColor((IPreferenceStore)pStore, (String)P_BACKGROUND_COLOR);
                        color = new ColorManager().getColor(rgb);
                        editor = (PropertiesEditor)editorPart;
                        editor.setBackground(color);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

