/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.task;

import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.slim3.gen.desc.ServiceDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.generator.ServiceGenerator;
import org.slim3.gen.generator.ServiceTestCaseGenerator;
import org.slim3.gen.task.AbstractGenJavaFileTask;
import org.slim3.gen.task.ClassNameBuilder;
import org.slim3.gen.task.JavaFile;
import org.slim3.gen.task.WebConfig;

public class GenServiceTask
extends AbstractGenJavaFileTask {
    protected String packageName;
    protected String superclassName = "java.lang.Object";
    protected String testCaseSuperclassName = "org.slim3.tester.AppEngineTestCase";
    protected String serviceDefinition;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setSuperclassName(String superclassName) {
        this.superclassName = superclassName;
    }

    public void setTestCaseSuperclassName(String testCaseSuperclassName) {
        this.testCaseSuperclassName = testCaseSuperclassName;
    }

    public void setServiceDefinition(String serviceDefinition) {
        this.serviceDefinition = serviceDefinition;
    }

    public void doExecute() throws Exception {
        super.doExecute();
        if (this.serviceDefinition == null) {
            throw new IllegalStateException("The serviceDefinition parameter is null.");
        }
        ServiceDesc serviceDesc = this.createServiceDesc();
        JavaFile javaFile = this.createJavaFile(serviceDesc);
        Generator generator = this.createServiceGenerator(serviceDesc);
        this.generateJavaFile(generator, javaFile);
        JavaFile testCaseJavaFile = this.createTestCaseJavaFile(serviceDesc);
        Generator testCaseGenerator = this.createServiceTestCaseGenerator(serviceDesc);
        this.generateJavaFile(testCaseGenerator, testCaseJavaFile);
    }

    private ServiceDesc createServiceDesc() throws IOException, XPathExpressionException {
        ClassNameBuilder nameBuilder = new ClassNameBuilder();
        nameBuilder.append(this.getServiceBasePackageName());
        nameBuilder.append(this.serviceDefinition);
        ServiceDesc serviceDesc = new ServiceDesc();
        serviceDesc.setPackageName(nameBuilder.getPackageName());
        serviceDesc.setSimpleName(nameBuilder.getSimpleName());
        serviceDesc.setSuperclassName(this.superclassName);
        serviceDesc.setTestCaseSuperclassName(this.testCaseSuperclassName);
        return serviceDesc;
    }

    protected String getServiceBasePackageName() throws IOException, XPathExpressionException {
        if (this.packageName != null) {
            return this.packageName;
        }
        WebConfig config = this.createWebConfig();
        StringBuilder buf = new StringBuilder();
        buf.append(config.getRootPackageName());
        if (config.isGWTServiceServletDefined()) {
            buf.append(".");
            buf.append("server");
        }
        buf.append(".");
        buf.append("service");
        return buf.toString();
    }

    protected Generator createServiceGenerator(ServiceDesc serviceDesc) {
        return new ServiceGenerator(serviceDesc);
    }

    protected Generator createServiceTestCaseGenerator(ServiceDesc serviceDesc) {
        return new ServiceTestCaseGenerator(serviceDesc);
    }
}

