/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.generator;

import org.slim3.gen.desc.ControllerDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.printer.Printer;
import org.slim3.gen.util.ClassUtil;

public class ControllerTestCaseGenerator
implements Generator {
    protected final ControllerDesc controllerDesc;

    public ControllerTestCaseGenerator(ControllerDesc controllerDesc) {
        if (controllerDesc == null) {
            throw new NullPointerException("The controllerDesc parameter is null.");
        }
        this.controllerDesc = controllerDesc;
    }

    public void generate(Printer p) {
        if (this.controllerDesc.getPackageName().length() != 0) {
            p.println("package %s;", this.controllerDesc.getPackageName());
            p.println();
        }
        if (!"java.lang.Object".equals(this.controllerDesc.getTestCaseSuperclassName())) {
            p.println("import %s;", this.controllerDesc.getTestCaseSuperclassName());
        }
        p.println("import %s;", "org.junit.Test");
        p.println("import static %s.*;", "org.junit.Assert");
        p.println("import static %s.*;", "org.hamcrest.CoreMatchers");
        p.println();
        p.print("public class %s%s", this.controllerDesc.getSimpleName(), "Test");
        if (!"java.lang.Object".equals(this.controllerDesc.getTestCaseSuperclassName())) {
            p.print(" extends %s", ClassUtil.getSimpleName(this.controllerDesc.getTestCaseSuperclassName()));
        }
        p.println(" {", new Object[0]);
        p.println();
        p.println("    @Test", new Object[0]);
        p.println("    public void run() throws Exception {", new Object[0]);
        p.println("        tester.start(\"%s\");", this.controllerDesc.getPath());
        p.println("        %s controller = tester.getController();", this.controllerDesc.getSimpleName());
        p.println("        assertThat(controller, is(notNullValue()));", new Object[0]);
        if (this.controllerDesc.isUseView()) {
            p.println("        assertThat(tester.isRedirect(), is(false));", new Object[0]);
            p.println("        assertThat(tester.getDestinationPath(), is(\"%s\"));", this.controllerDesc.getViewName());
        } else {
            p.println("        assertThat(tester.isRedirect(), is(false));", new Object[0]);
            p.println("        assertThat(tester.getDestinationPath(), is(nullValue()));", new Object[0]);
        }
        p.println("    }", new Object[0]);
        p.println("}", new Object[0]);
    }
}

