/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.desc;

import org.slim3.gen.util.ClassUtil;
import org.slim3.gen.util.StringUtil;

public class ModelMetaClassName {
    protected final String modelClassName;
    protected final String modelPackage;
    protected final String metaPackage;
    protected final String sharedPackage;
    protected final String serverPackage;
    protected final String packageName;
    protected final String simpleName;
    protected final String kind;

    public ModelMetaClassName(String modelClassName, String modelPackage, String metaPackage, String sharedPackage, String serverPackage) {
        if (modelClassName == null) {
            throw new NullPointerException("The modelClassName parameter is null.");
        }
        if (modelPackage == null) {
            throw new NullPointerException("The modelPackage parameter is null.");
        }
        if (metaPackage == null) {
            throw new NullPointerException("The metaPackage parameter is null.");
        }
        if (sharedPackage == null) {
            throw new NullPointerException("The sharedPackage parameter is null.");
        }
        if (serverPackage == null) {
            throw new NullPointerException("The serverPackage parameter is null.");
        }
        this.modelClassName = modelClassName;
        this.modelPackage = modelPackage;
        this.metaPackage = metaPackage;
        this.sharedPackage = sharedPackage;
        this.serverPackage = serverPackage;
        modelClassName = this.replacePackageName(modelClassName, modelPackage, metaPackage);
        modelClassName = this.replacePackageName(modelClassName, sharedPackage, serverPackage);
        this.packageName = ClassUtil.getPackageName(modelClassName);
        this.simpleName = ClassUtil.getSimpleName(modelClassName) + "Meta";
        this.kind = ClassUtil.getSimpleName(modelClassName);
    }

    protected String replacePackageName(String originalPackageName, String from, String to) {
        if (StringUtil.isEmpty(originalPackageName)) {
            return originalPackageName;
        }
        int index = originalPackageName.lastIndexOf("." + from + ".");
        if (index < 0) {
            return originalPackageName;
        }
        return originalPackageName.substring(0, index) + "." + to + "." + originalPackageName.substring(index + from.length() + 2);
    }

    public String getQualifiedName() {
        return ClassUtil.getQualifiedName(this.packageName, this.simpleName);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getKind() {
        return this.kind;
    }
}

