<?php
App::import('Controller', 'PrimoccoAuth');

/**
 *
 * @author pippine
 *
 */
class MypageController extends PrimoccoAuthController {

	public $uses = array("Category", "Member", "Poster", "Top");

	public function index() {
		$this->set("member", $this->getMember());
		$member = $this->getMember();
		$this->set('myPosterList', $this->Poster->find('all', array("conditions" => array("Poster.member_id" => $member["Member"]["id"]))));
		$this->set('topCount', $this->Top->find('count', array('conditions' => array('Top.member_id' => $member['Member']['id']))));
		$this->render("mypage");
	}


	public function profile() {
		$this->set("member", $this->getMember());
		$member = $this->getMember();
		$this->set('myPosterList', $this->Poster->find('all', array("conditions" => array("Poster.member_id" => $member["Member"]["id"]))));
		$this->render("profile");
	}

	public function profileUpdate() {
		$member = $this->getMember();
		$this->set("member", $member);

		$nickname = $this->data['Mypage']['nickname'];

		if ($nickname == null) {
			$this->set("error", "変更後のニックネームを入力してください。");
			$this->render("profile");
		}
		$member['Member']['nickname'] = $nickname;
		$fields = array('nickname');
		$this->Member->save($member,true,$fields);

		$this->Session->write($this->SESSION_KEY_MEMBER,$member);

		$this->set("member", $member);
		$this->set('mode',"success");
		$this->render("profile");
	}


	public function password() {
		$this->set("member", $this->getMember());
		$member = $this->getMember();
		$this->render("password");
	}

	public function passwordUpdate() {
		$member = $this->getMember();
		$this->set("member", $member);

		$oldpass = $this->data['Mypage']['oldpass'];
		$newpass = $this->data['Mypage']['newpass'];
		$newpass2 = $this->data['Mypage']['newpass2'];

		if ($oldpass == null ||$newpass == null|| $newpass2 == null) {
			$this->set("error", "すべて入力してください。");
			$this->render("password");
		}

		if(hash("md5",$oldpass) != $member["Member"]['password']){
			$this->set("error", "現在のパスワードが間違えています。");
			$this->render("password");
		}

		if ($newpass != $newpass2) {
			$this->set("error", "新しいパスワードが正しく入力されていません。");
			$this->render("password");
		}

		$member["Member"]['password'] = hash("md5",$newpass);
		$fields = array('password');
		$this->Member->save($member,true,$fields);

		$this->Session->write($this->SESSION_KEY_MEMBER,$member);
		$this->set("member", $member);
		$this->set('mode',"success");
		$this->render("password");
	}



}