<?php
/**
 * 画像を加工するコンポーネントクラス
 *
 * @author tsuuru
 */
class ImageComponent extends Component {

	/**
	 *
	 * @param unknown_type $inpFile
	 * @param unknown_type $outFile
	 * @param unknown_type $size
	 * @return unknown_type
	 */
	public function resizeJpegFile($inpFile, $outFile, $size) {

		$im_inp = ImageCreateFromJPEG($inpFile);
		$ix = ImageSX($im_inp);
		$iy = ImageSY($im_inp);
		$ox = 0;
		$oy = 0;
		if ($ix >= $iy) {
			$ox = $size;
			$oy = ($ox * $iy) / $ix;
		} else {
			$oy = $size;
			$ox = ($oy * $ix) / $iy;
		}

		// サイズ変更後の画像データを生成
		$im_out = ImageCreateTrueColor($ox, $oy);
		ImageCopyResized($im_out, $im_inp, 0, 0, 0, 0, $ox, $oy, $ix, $iy);

		// 画像の保存
		header('Content-Type: image/jpeg');
		header("Cache-control: no-cache");
		ImageJPEG($im_out, $outFile);

		ImageDestroy($im_inp);
		ImageDestroy($im_out);
	}
}