#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <libxml/xmlreader.h>

#include "playerstatus.h"

#if 0
static int readfile(char *contents)
{
    FILE *fp;
    char *fname = "/Users/yoshi/Downloads/getplayerstatus.xml";
    char s[100];
    
    fp = fopen( fname, "r" );
    if( fp == NULL ){
        printf( "%sファイルが開けません\n", fname );
        return -1;
    }
    
    printf( "\n-- fgets() --\n" );
    while( fgets( s, 100, fp ) != NULL ){
        strcat(contents, s);
    }
    printf( "\n-- fgets() done --\n" );
    fclose( fp );
    return 0;
}
#endif




//  現在パース中のノード名
typedef enum {
    STATE_NONE,
    STATE_GETPLAYERSTATUS,//getplayerstatus
    STATE_ERROR,//error
    STATE_TITLE,//title
    STATE_DESCRIPTION,//description
    STATE_PROVIDER_TYPE,//provider_type
    STATE_COMMUNITY,//default_community
    STATE_IS_OWNER,//is_owner
    STATE_OWNER,//owner_id
    STATE_OWNER_NAME,//owner_name
    STATE_IS_RESERVED,//is_reserved 予約枠
    STATE_START_TIME,//start_time
    STATE_END_TIME,//end_time
    STATE_CONTENTS,//contents
    STATE_RTMP,//rtmp
    STATE_URL,//url
    STATE_TICKET,//ticket
    STATE_MS,//ms
    STATE_ADDR,//addr コメ鯖
    STATE_PORT,//port ポート
    STATE_THREAD,//thread
    STATE_USER_ID,
    STATE_IS_PREMIUM
} parsingStatus;


//  1つのノードを処理する
void processNode(xmlTextReaderPtr reader, NICO_LIVE* session)
{
    static parsingStatus state = STATE_NONE;
    xmlElementType nodeType;
    xmlChar *name, *value;
    
    //  ノード情報の取得
    nodeType = xmlTextReaderNodeType(reader);       //  ノードタイプ
    name = xmlTextReaderName(reader);               //  ノード名
    if (!name)
        name = xmlStrdup(BAD_CAST "---");
    //printf("Node name:%s\n", name);
    if (nodeType == XML_READER_TYPE_ELEMENT) {              //  開始
        if ( xmlStrcmp(name, BAD_CAST "getplayerstatus") == 0 ) {
            state = STATE_GETPLAYERSTATUS;
        } else if ( xmlStrcmp(name, BAD_CAST "title") == 0 ) {
            state = STATE_TITLE;
        } else if ( xmlStrcmp(name, BAD_CAST "description") == 0 ) {
            state = STATE_DESCRIPTION;
        } else if ( xmlStrcmp(name, BAD_CAST "provider_type") == 0 ) {
            state = STATE_PROVIDER_TYPE;
        } else if ( xmlStrcmp(name, BAD_CAST "default_community") == 0 ) {
            state = STATE_COMMUNITY;
        } else if ( xmlStrcmp(name, BAD_CAST "is_owner") == 0 ) {
            state = STATE_IS_OWNER;
        } else if ( xmlStrcmp(name, BAD_CAST "owner_id") == 0 ) {
            state = STATE_OWNER;
        } else if ( xmlStrcmp(name, BAD_CAST "owner_name") == 0 ) {
            state = STATE_OWNER_NAME;
        } else if ( xmlStrcmp(name, BAD_CAST "is_reserved") == 0 ) {
            state = STATE_IS_RESERVED;
        } else if ( xmlStrcmp(name, BAD_CAST "start_time") == 0 ) {
            state = STATE_START_TIME;
        } else if ( xmlStrcmp(name, BAD_CAST "end_time") == 0 ) {
            state = STATE_END_TIME;
        } else if ( xmlStrcmp(name, BAD_CAST "contents") == 0 ) {
            state = STATE_CONTENTS;
        } else if ( xmlStrcmp(name, BAD_CAST "rtmp") == 0 ) {
            state = STATE_RTMP;
        } else if ( xmlStrcmp(name, BAD_CAST "url") == 0 ) {
            state = STATE_URL;
        } else if ( xmlStrcmp(name, BAD_CAST "ticket") == 0 ) {
            state = STATE_TICKET;
        } else if ( xmlStrcmp(name, BAD_CAST "ms") == 0 ) {
            state = STATE_MS;
        } else if ( xmlStrcmp(name, BAD_CAST "addr") == 0 ) {
            state = STATE_ADDR;
        } else if ( xmlStrcmp(name, BAD_CAST "port") == 0 ) {
            state = STATE_PORT;
        } else if ( xmlStrcmp(name, BAD_CAST "thread") == 0 ) {
            state = STATE_THREAD;
        } else if ( xmlStrcmp(name, BAD_CAST "user_id") == 0 ) {
            state = STATE_USER_ID;
        } else if ( xmlStrcmp(name, BAD_CAST "is_premium") == 0 ) {
            state = STATE_IS_PREMIUM;
        }
        
    } else if (nodeType == XML_READER_TYPE_END_ELEMENT) {   //  終了
        if ( xmlStrcmp(name, BAD_CAST "getplayerstatus") == 0 ) {
            printf("-----------------------\n");
        }

        state = STATE_NONE;
        
    } else if (nodeType == XML_READER_TYPE_TEXT) {          //  テキスト
        //  テキストを取得する
        value = xmlTextReaderValue(reader);
        
        if (!value)
            value = xmlStrdup(BAD_CAST "---");
        
        if ( state == STATE_ERROR ) {/////////// ToDo: switch-caseに書き換え
            printf("[ERROR] Reason: %s\n", value);
            return;
        } else if ( state == STATE_TITLE ) {
            //printf("STATE_TITLE: %s\n", value);
            (*session).title = (char*)malloc( strlen(value) + 1 );
            strcpy((*session).title, (const char *)value);
        } else if ( state == STATE_DESCRIPTION ) {
            //printf("STATE_DESCRIPTION: %s\n", value);
            (*session).description = (char*)malloc( strlen(value) + 1 );
            strcpy((*session).description, (const char *)value);
        } else if ( state == STATE_PROVIDER_TYPE ) {
            // "official" "community"
            //printf("STATE_PROVIDER_TYPE: %s\n", value);
            (*session).provider_type = (char*)malloc( strlen(value) + 1 );
            strcpy((*session).provider_type, (const char *)value);
        } else if ( state == STATE_COMMUNITY ) {
            //owner_id
            //(*session).owner_id = (char*)malloc( strlen(value) + 1 );
            //strcpy((*session).owner_id, (const char *)value);
        } else if ( state == STATE_IS_OWNER ) {
            //printf("STATE_IS_OWNER: %s\n", value);
            (*session).is_owner = value[0] - '0';
        } else if ( state == STATE_OWNER ) {
            //
        } else if ( state == STATE_OWNER_NAME ) {
            //printf("STATE_OWNER_NAME: %s\n", value);
            (*session).owner_name = (char*)malloc( strlen(value) + 1 );
            strcpy((*session).owner_name, (const char *)value);
        } else if ( state == STATE_IS_RESERVED ) {
            //
        } else if ( state == STATE_START_TIME ) {
            //
        } else if ( state == STATE_END_TIME ) {
            //
        } else if ( state == STATE_CONTENTS ) {
            //printf("N: %s\n", value);
            (*session).contents = (char*)malloc( strlen(value) + 1 - 5);
            strcpy((*session).contents, (const char *)value + 5);
        } else if ( state == STATE_RTMP ) {
            //
        } else if ( state == STATE_URL ) {
            //printf("STATE_URL: %s\n", value);
            (*session).url = (char*)malloc( strlen(value) + 1 );
            strcpy((*session).url, (const char *)value);
        } else if ( state == STATE_TICKET ) {
            //printf("STATE_TICKET: %s\n", value);
            (*session).ticket = (char*)malloc( strlen(value) + 1 );
            strcpy((*session).ticket, (const char *)value);
        } else if ( state == STATE_MS ) {
            //
        } else if ( state == STATE_ADDR ) {
            //printf("STATE_ADDR: %s\n", value);
            (*session).msg_addr = (char*)malloc( strlen(value) + 1 );
            strcpy((*session).msg_addr, (const char *)value);
        } else if ( state == STATE_PORT ) {
            //printf("STATE_PORT: %s\n", value);
            sscanf((const char *)value,"%d",&((*session).msg_port));
        } else if ( state == STATE_THREAD ) {
            //printf("STATE_THREAD: %s\n", value);
            //(*session).thread = (char*)malloc( strlen(value) + 1 );
            sscanf((const char *)value,"%d",&((*session).thread));
        } else if ( state == STATE_USER_ID ) {
            printf("USER ID = %s\n",value);
            (*session).user_id = (char*)malloc( strlen(value) + 1 );
            strcpy((*session).user_id, (const char *)value);
        } else if ( state == STATE_IS_PREMIUM ) {
            //printf("Premium = %s\n",(value[0]=='1')?"yes":"no");
            (*session).is_premium = (value[0]=='1');
        }
       
        xmlFree(value);
    }
    
    xmlFree(name);
}

NICO_LIVE *new_nico_live(char* playerstatus)
{
    
    xmlTextReaderPtr reader;
    int ret;
    NICO_LIVE *session = (NICO_LIVE*)malloc( sizeof(NICO_LIVE) );
    
    //  Readerの作成
    reader = xmlReaderForDoc((xmlChar*)playerstatus, NULL, NULL, 1);
    if ( !reader ) {
        printf("Failed to open XML\n");
        return (NICO_LIVE*)-1;
    }
    
    
    //  次のノードに移動
    ret = xmlTextReaderRead(reader);
    while (ret == 1) {
        //  現在のノードを処理
        processNode(reader, session);
        
        //  次のノードに移動
        ret = xmlTextReaderRead(reader);
    }
    
    //  Reader のすべてのリソースを開放
    xmlFreeTextReader(reader);
    
    //  xmlTextReaderRead の戻り値が -1 だった場合はパースエラー
    if (ret == -1) {
        printf("Parse error.\n");
        return (NICO_LIVE*)-1;
    }
    
    return session;
    
}

int nico_live_close(NICO_LIVE* broadcast)
{
    free(broadcast);
    return 0;
}

#if 0
int main (int argc, char *argv[])
{
    char* contents = (char *)malloc(sizeof(char) * 8192);
    
    readfile(contents);
    
    // XML処理

    NICO_LIVE *broadcast = new_nico_live(contents);
    
 //
    printf("放送タイトル:%s\n説明:%s\n放送主:%s\n",(*broadcast).title,(*broadcast).description,(*broadcast).owner_name);
    printf("コメ鯖:%s\nポート:%d\nスレッド:%d\n",(*broadcast).msg_addr,(*broadcast).msg_port,(*broadcast).thread);
    
    nico_live_close(broadcast);
    
    // XML処理完了
    
    free(contents);
    
    return 0;
}
#endif