#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/param.h>
#include <sys/uio.h>
#include <unistd.h>

#include "XmlSocket.h"


XML_SOCKET *xml_socket_open(const char *host, unsigned short port, int (*OnRecieve)(char* xml_msg, void *data), void *data)
{
    
    if(host == 0)    /* リクエスト先確認機構 */
    {
        return (XML_SOCKET*) -1;
    }
    
    struct hostent *servhost;            /* ホスト名と IP アドレスを扱うための構造体 */
    struct sockaddr_in server;           /* ソケットを扱うための構造体 */
    struct servent *service;             /* サービス (http など) を扱うための構造体 */
    FILE *fp;                            /* ソケット用の FILE 構造体 */
    int s;                               /* ソケットのためのファイルディスクリプタ */
    
    XML_SOCKET *session = (XML_SOCKET*)malloc( sizeof(XML_SOCKET) );
    
    
    printf("%s:%d に接続します。\n\n",host, port);
    
    /* ホストの情報(IPアドレスなど)を取得 */
    servhost = gethostbyname(host);
    if ( servhost == NULL ){
        fprintf(stderr, "[ERROR] IP LOOKUP FOR %s FAILED.\n", host);
        return (XML_SOCKET*) -1;
    }
    
    bzero((char *)&server, sizeof(server));     /* 構造体をゼロクリア */
    
    server.sin_family = AF_INET;
    
    /* IPアドレスを示す構造体をコピー */
    bcopy(servhost->h_addr, (char *)&server.sin_addr, servhost->h_length);
    
    server.sin_port = htons(port);
    
    /* ソケット生成 */
    if ( ( s = socket(AF_INET, SOCK_STREAM, 0) ) < 0 ){
        fprintf(stderr, "[ERROR] Socket creation failed.\n");
        return (XML_SOCKET*) -1;
    }
    /* サーバに接続 */
    if ( connect(s, (struct sockaddr *)&server, sizeof(server)) == -1 ){
        fprintf(stderr, "[ERROR] Connection was not established.\n");
        return (XML_SOCKET*) -1;
    }
    /* FILE 構造体を作成 */
    fp = fdopen(s, "r+");
    if ( fp == NULL ){
        fprintf(stderr, "[ERROR] File descripter was not created from specified socket.\n");
        return (XML_SOCKET*) -1;
    }
    /* バッファリング OFF */
    setvbuf(fp, NULL, _IONBF, 0);
    
    *session = (XML_SOCKET){s, fp, host, port, OnRecieve, data, 0};
    
    return session;
}

int xml_socket_close(XML_SOCKET *session)
{
    pthread_cancel((*session).thread);
    
    fclose((*session).fp);
    close((*session).socket_fd);
    
    pthread_join((*session).thread , NULL);
    
    free(session);
    
    return 0;
}

int xml_socket_request(XML_SOCKET *session, const char* value)
{
    //きっちり全部送信
    fwrite( value, strlen(value) + sizeof(char), 1, (*session).fp );
    
    return 0;
}

void *thread_xml_socket(void *param)
{
    XML_SOCKET *session = (XML_SOCKET *)param;
    
    char buf[1];
    //    printf("xml_socket_retrieve()\n");
    char *xml_msg = (char *)malloc(sizeof(char) * 1024);
    //一応、初期化しとく。
    memset(xml_msg, 0, malloc_size(xml_msg));
    
    while (1){
        /* 通信が切断されたっぽかったら、おしまい */
        if ( fread(buf, sizeof(buf), 1, (*session).fp) < 1 ){
            printf("end\n");
            break;
        }
        //printf("read, [%c]=0x%02x, current buf=%s\n", buf[0],buf[0],xml_msg);
        strcat(xml_msg, buf);
        //XmlSocketプロトコルの終端文字を検出したら、
        if (buf[0] == '\0') { //unlikely
            //パーサーに投げて、（スレッド立てた方がいい？）
            (*session).OnRecieve(xml_msg, (*session).data);//終了するかどうか返り値見たほうがいいかな
            //領域クリア。
            memset(xml_msg, 0, malloc_size(xml_msg));
            pthread_testcancel(); //スレッドの実行を継続していいか確認
        }
        
        //        printf("%s", buf);
    }
    free(xml_msg);
}

int xml_socket_retrieve(XML_SOCKET *session)
{
    
    if ((*session).thread == 0) {
        
        if(pthread_create(&((*session).thread) , NULL , thread_xml_socket , session) !=0)
            perror("pthread_create()");
        
    }else
    {
        //error thread already exists.
    }

    
    return 0;
}