<?php
// PukiWiki - Yet another WikiWikiWeb clone.
// $Id: pukiwiki.skin.php,v 1.56 2007/07/26 00:57:00 henoheno Exp $
// Copyright (C)
//   2002-2007 PukiWiki Developers Team
//   2001-2002 Originally written by yu-ji
// License: GPL v2 or (at your option) any later version
//
// PukiWiki default skin

// ------------------------------------------------------------
// Settings (define before here, if you want)

// Set site identities
$_IMAGE['skin']['logo']     = 'sample_logo1.png';
$_IMAGE['skin']['favicon']  = ''; // Sample: 'image/favicon.ico';

// SKIN_DEFAULT_DISABLE_TOPICPATH
//   1 = Show reload URL
//   0 = Show topicpath
if (! defined('SKIN_DEFAULT_DISABLE_TOPICPATH'))
	define('SKIN_DEFAULT_DISABLE_TOPICPATH', 1); // 1, 0

// Show / Hide navigation bar UI at your choice
// NOTE: This is not stop their functionalities!
if (! defined('PKWK_SKIN_SHOW_NAVBAR'))
	define('PKWK_SKIN_SHOW_NAVBAR', 1); // 1, 0

// Show / Hide toolbar UI at your choice
// NOTE: This is not stop their functionalities!
if (! defined('PKWK_SKIN_SHOW_TOOLBAR'))
	define('PKWK_SKIN_SHOW_TOOLBAR', 1); // 1, 0

// ------------------------------------------------------------
// Code start

// Prohibit direct access
if (! defined('UI_LANG')) die('UI_LANG is not set');
if (! isset($_LANG)) die('$_LANG is not set');
if (! defined('PKWK_READONLY')) die('PKWK_READONLY is not set');

$lang  = & $_LANG['skin'];
$link  = & $_LINK;
$image = & $_IMAGE['skin'];
$rw    = ! PKWK_READONLY;

// Decide charset for CSS
$css_charset = 'iso-8859-1';
switch(UI_LANG){
	case 'ja': $css_charset = 'Shift_JIS'; break;
}

// MenuBar
$menu = arg_check('read') && exist_plugin_convert('menu') ? do_plugin_convert('menu') : FALSE;

// ------------------------------------------------------------
// Output

// HTTP headers
pkwk_common_headers();
header('Cache-control: no-cache');
header('Pragma: no-cache');
header('Content-Type: text/html; charset=' . CONTENT_CHARSET);

// HTML DTD, <html>, and receive content-type
if (isset($pkwk_dtd)) {
	$meta_content_type = pkwk_output_dtd($pkwk_dtd);
} else {
	$meta_content_type = pkwk_output_dtd();
}

?>
<head>
 <?php echo $meta_content_type ?>
 <meta http-equiv="content-style-type" content="text/css" />
<?php if ($nofollow || ! $is_read)  { ?> <meta name="robots" content="NOINDEX,NOFOLLOW" /><?php } ?>
<?php if (PKWK_ALLOW_JAVASCRIPT && isset($javascript)) { ?> <meta http-equiv="Content-Script-Type" content="text/javascript" /><?php } ?>

 <title><?php echo $title ?> - <?php echo $page_title ?></title>

 <link rel="SHORTCUT ICON" href="<?php echo $image['favicon'] ?>" />
 <link rel="stylesheet" type="text/css" media="screen" href="<?php echo SKIN_DIR ?>pukiwiki.css.php?charset=<?php echo $css_charset ?>" charset="<?php echo $css_charset ?>" />
 <link rel="stylesheet" type="text/css" media="print"  href="<?php echo SKIN_DIR ?>pukiwiki.css.php?charset=<?php echo $css_charset ?>&amp;media=print" charset="<?php echo $css_charset ?>" />
 <link rel="alternate" type="application/rss+xml" title="RSS" href="<?php echo $link['rss'] ?>" /><?php // RSS auto-discovery ?>

<?php echo $head_tag ?>
</head>
<body>

<div id="header">
 <a href="<?php echo $link['top'] ?>"><img id="logo"
     src="<?php echo IMAGE_DIR . $image['logo'] ?>"
     width="80" height="80"
     alt="<?php echo HtmlUtils::escapeHTML($page_title); ?>"
     title="<?php echo HtmlUtils::escapeHTML($page_title); ?>" /></a>

 <h1 class="title"><?php echo $page ?></h1>

<?php if ($is_page) { ?>
 <?php if(SKIN_DEFAULT_DISABLE_TOPICPATH) { ?>
   <a href="<?php echo $link['reload'] ?>"><span class="small"><?php echo $link['reload'] ?></span></a>
 <?php } else { ?>
   <span class="small">
   <?php require_once(PLUGIN_DIR . 'topicpath.inc.php'); echo plugin_topicpath_inline(); ?>
   </span>
 <?php } ?>
<?php } ?>

</div>

<div id="navigator">
<?php
// local var scope on html.php function catbody : not global
   if(PKWK_SKIN_SHOW_NAVBAR)
   {
        function _navigator($key, $value = '', $javascript = '')
        {
            $lang = & $GLOBALS['_LANG']['skin'];
            $link = & $GLOBALS['_LINK'];
            if (! isset($lang[$key])) { echo 'LANG NOT FOUND'; return FALSE; }
            if (! isset($link[$key])) { echo 'LINK NOT FOUND'; return FALSE; }
            if (! PKWK_ALLOW_JAVASCRIPT) $javascript = '';

            echo '<a href="' . $link[$key] . '" ' . $javascript . '>' .
                (($value === '') ? $lang[$key] : $value) .
                '</a>';

            return TRUE;
        }

        function _add_linklist_from_global_link(&$lists , $key, $value = '', $javascript = '')
        {
            $lang = & $GLOBALS['_LANG']['skin'];
            $link = & $GLOBALS['_LINK'];
            if (! isset($lang[$key])) { echo 'LANG NOT FOUND'; return FALSE; }
            if (! isset($link[$key])) { echo 'LINK NOT FOUND'; return FALSE; }
            if (! PKWK_ALLOW_JAVASCRIPT) $javascript = '';

            if (!isset($lists) || is_null($lists))
            {
                $lists = array();
            }
            $lists[] =  sprintf('<a href="%s" %s>%s</a>' ,
                                $link[$key] ,
                                $javascript ,
                                (($value === '') ? $lang[$key] : $value)
                                    );
            return TRUE;
        }

        function _make_navi($target_keys, $allow_keys)
        {
            $navi = array();

            $no_items =  array_diff($target_keys , $allow_keys);
            $keys = array_diff($target_keys , $no_items);

            if ( count($keys) < 1 )
               return '';

            $navi = array();
            foreach($keys as $key)
            {
               _add_linklist_from_global_link($navi ,  $key);
            }
            return "[ " . implode(' | ', $navi) ." ]";
        }

        function _show_navi1($allow_keys)
        {
            $items = array('edit', 'freeze', 'unfreeze',
                           'diff', 'backup', 'file_uploads', 'upload', 'reload');
            $s = _make_navi($items, $allow_keys);
            echo ($s ? $s.' &nbsp;' : '');
        }

        function _show_navi2($allow_keys)
        {
            $items = array('new', 'list', 'filelist', 'search', 'recent', 'help');
            echo _make_navi($items, $allow_keys);
        }

        echo '[ ' ;  _navigator('top');  echo ' ] &nbsp;';
       _show_navi1($navi_link_keys_for_user);
       _show_navi2($navi_link_keys_for_user);
    } // PKWK_SKIN_SHOW_NAVBAR ?>
</div>

<?php echo $hr ?>

<?php if ($menu !== FALSE) { ?>
<table border="0" style="width:100%">
 <tr>
  <td class="menubar">
   <div id="menubar"><?php echo $menu ?></div>
  </td>
  <td valign="top">
   <div id="body"><?php echo $body ?></div>
  </td>
 </tr>
</table>
<?php } else { ?>
<div id="body"><?php echo $body ?></div>
<?php } ?>

<?php if ($notes != '') { ?>
<div id="note"><?php echo $notes ?></div>
<?php } ?>

<?php if ($attaches != '') { ?>
<div id="attach">
<?php echo $hr ?>
<?php echo $attaches ?>
</div>
<?php } ?>

<?php echo $hr ?>

<?php
if (PKWK_SKIN_SHOW_TOOLBAR)
{
    global $_IMAGE_SIZE;
    if (!isset($_IMAGE_SIZE))
        $_IMAGE_SIZE = array();
    if (!isset($_IMAGE_SIZE['skin']))
        $_IMAGE_SIZE['skin'] = array();

    // Set toolbar-specific images
    $_IMAGE['skin']['reload']   = 'reload.png';
    $_IMAGE['skin']['new']      = 'new.png';
    $_IMAGE['skin']['edit']     = 'edit.png';
    $_IMAGE['skin']['freeze']   = 'freeze.png';
    $_IMAGE['skin']['unfreeze'] = 'unfreeze.png';
    $_IMAGE['skin']['diff']     = 'diff.png';
    $_IMAGE['skin']['upload']   = 'file.png';
    $_IMAGE['skin']['copy']     = 'copy.png';
    $_IMAGE['skin']['rename']   = 'rename.png';
    $_IMAGE['skin']['top']      = 'top.png';
    $_IMAGE['skin']['list']     = 'list.png';
    $_IMAGE['skin']['search']   = 'search.png';
    $_IMAGE['skin']['recent']   = 'recentchanges.png';
    $_IMAGE['skin']['backup']   = 'backup.png';
    $_IMAGE['skin']['help']     = 'help.png';
    $_IMAGE['skin']['rss']      = 'rss.png';
    $_IMAGE['skin']['rss10']    = & $_IMAGE['skin']['rss'];
    $_IMAGE['skin']['rss20']    = 'rss20.png';
    $_IMAGE['skin']['rdf']      = 'rdf.png';

    $_IMAGE_SIZE['skin']['rss']   = array(36, 14);
    $_IMAGE_SIZE['skin']['rss10'] = array(36, 14);
    $_IMAGE_SIZE['skin']['rss20'] = array(54, 14);
    $_IMAGE_SIZE['skin']['rdf']   = array(36, 14);
    $_IMAGE_SIZE['skin']['atom']  = array(36, 14);

    function _toolbar($key, $x = 20, $y = 20)
    {
        $lang  = & $GLOBALS['_LANG']['skin'];
        $link  = & $GLOBALS['_LINK'];
        $image = & $GLOBALS['_IMAGE']['skin'];
        if (! isset($lang[$key]) ) { echo 'LANG NOT FOUND';  return FALSE; }
        if (! isset($link[$key]) ) { echo 'LINK NOT FOUND';  return FALSE; }
        if (! isset($image[$key])) { echo 'IMAGE NOT FOUND'; return FALSE; }

        $image_size = & $GLOBALS['_IMAGE_SIZE']['skin'];
        if (isset($image_size[$key]))
        {
            $x = (string) $image_size[$key][0];
            $y = (string) $image_size[$key][1];
        }

        echo '<a href="' . $link[$key] . '">' .
            '<img src="' . IMAGE_DIR . $image[$key] . '" width="' . $x . '" height="' . $y . '" ' .
                'alt="' . $lang[$key] . '" title="' . $lang[$key] . '" />' .
            '</a>';
        return TRUE;
    }

    echo "\n";
    echo "<!-- Toolbar -->\n";
    echo '<div id="toolbar">' . "\n";

    $toolbars = array();
    $toolbars[] = array('top');
    if ($is_page)
    {
        $toolbars[] = array('edit','freeze','unfreeze','diff','backup','upload',
                            'copy','rename','reload');
    }
    $toolbars[] = array('new','list','search','recent');
    $toolbars[] = array('help');
    $toolbars[] = array('rss10');

    $ct_p = 0;
    foreach($toolbars as $toolbar)
    {
        $ct_c = 0;
        foreach($toolbar as $v)
        {
           if ( in_array ($v , $navi_link_keys_for_user ))
           {
              if ( $ct_c == 0 )
              {
                  if ( $ct_p != 0 )
                     echo '&nbsp;&nbsp;&nbsp;';
                  $ct_p++;
              }
              else
                echo "&nbsp;";
              _toolbar($v);
              $ct_c++;
           }
        }
    }

    echo "</div>\n\n";

//    var_dump(array_diff(array_keys($_LINK), $navi_link_keys_for_user)); // for debug

} // PKWK_SKIN_SHOW_TOOLBAR

// OUTPUT_HIDE_LASTMODIFIED = FALSE
if ( (! defined('OUTPUT_HIDE_LASTMODIFIED')) || (! OUTPUT_HIDE_LASTMODIFIED) )
{
    if ($lastmodified != '')
        echo '<div id="lastmodified">Last-modified: '. $lastmodified .'</div>'."\n";
}

if ($related != '')
{
    echo '<div id="related">Link: ' . $related . '</div>'."\n";
}

// footer
    echo "\n<div id=\"footer\">\n";

    // Site administrator
    printf('    Site administrator: <a href="%s">%s</a><p />'."\n" , $modifierlink , $modifier);

    // hr
    echo '    <hr style="border-style: dotted; border-color: #CCFFCC; padding: 1">'."\n";

    $s = array( 'h' => array() , 'b' => array() , 'f' => array() );
    $s['h'][] = '<div style="text-align: right; float:right; font-size: xx-small">';
    $s['f'][] = '</div>';

    // OUTPUT_HIDE_CORE_POWERDBY = FALSE
    if ( (! defined('OUTPUT_HIDE_CORE_POWERDBY')) || (! OUTPUT_HIDE_CORE_POWERDBY) )
        $s['b'][] = S_COPYRIGHT;

    // HIDE_VERSION_STRING = FALSE
    if ( (! defined('HIDE_VERSION_STRING')) || (! HIDE_VERSION_STRING ))
      $s['b'][] = "<br />\n Powered by PHP " . PHP_VERSION;

    if (count($s['b'])>0)
    {
        foreach( array('h','b','f') as $k )
        {
            echo "    " . implode("\n", $s[$k]) . "\n";
        }
    }

  // OUTPUT_HIDE_CONVERT_TIME = FALSE
  if ( (! defined('OUTPUT_HIDE_CONVERT_TIME')) || (! OUTPUT_HIDE_CONVERT_TIME) )
  {
     echo '    <div style="text-align: left; font-size: small">HTML convert time: ';
     echo elapsedtime();
     echo " sec. </div>\n";
  }
?>
</div>

</body>
</html>
