<?php
/*
 * PopoWiki   PHP Web Wiki System (http://popowiki.sourceforge.jp/)
 * Copyright (C) 2014 PopoWiki Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * (see License/ for more info)
 */

/**
 * popowiki.skin.php
 *
 * PopoWiki default skin
 *
 * Copyright (C)
 *    2014 PopoWiki Project
 *    2002-2011 PukiWiki Developers Team
 *    2001-2002 Originally written by yu-ji
 */
// ------------------------------------------------------------
// PukiWiki - Yet another WikiWikiWeb clone.
// $Id: pukiwiki.skin.php,v 1.56 2007/07/26 00:57:00 henoheno Exp $
// Copyright (C)
//   2002-2007 PukiWiki Developers Team
//   2001-2002 Originally written by yu-ji
// License: GPL v2 or (at your option) any later version
//
//

// ------------------------------------------------------------
// Settings (define before here, if you want)

// Set site identities
$_IMAGE['skin']['logo']     = 'sample_logo1.png';
$_IMAGE['skin']['favicon']  = ''; // Sample: 'image/favicon.ico';
$_IMAGE_SIZE['skin']['logo']     = array(80,80); // (width , height)

// SKIN_DEFAULT_DISABLE_TOPICPATH
//   1 = Show reload URL
//   0 = Show topicpath
if (! defined('SKIN_DEFAULT_DISABLE_TOPICPATH'))
	define('SKIN_DEFAULT_DISABLE_TOPICPATH', 1); // 1, 0

// Show / Hide navigation bar UI at your choice
// NOTE: This is not stop their functionalities!
if (! defined('PKWK_SKIN_SHOW_NAVBAR'))
	define('PKWK_SKIN_SHOW_NAVBAR', 1); // 1, 0

// Show / Hide toolbar UI at your choice
// NOTE: This is not stop their functionalities!
if (! defined('PKWK_SKIN_SHOW_TOOLBAR'))
	define('PKWK_SKIN_SHOW_TOOLBAR', 1); // 1, 0

// ------------------------------------------------------------
// Code start

// Prohibit direct access
if (! defined('UI_LANG')) die('UI_LANG is not set');
if (! isset($_LANG)) die('$_LANG is not set');
if (! defined('PKWK_READONLY')) die('PKWK_READONLY is not set');

$lang  = & $_LANG['skin'];
$link  = & $_LINK;
$image = & $_IMAGE['skin'];
$rw    = ! PKWK_READONLY;

// Decide charset for CSS
$css_charset = 'iso-8859-1';
switch(UI_LANG){
	case 'ja': $css_charset = 'Shift_JIS'; break;
}

// MenuBar
// $menu2 : set --> read
$menu = arg_check('read') && exist_plugin_convert('menu') ? do_plugin_convert('menu') : FALSE;
$menu2 =  '';

global $MenuBar_Right , $vars;
// $MenuBar_Right : Show right menu
// 'source_html_tag' => head, foot
// 'menu_pagename' は includeで展開され head と footの間に挿入されます
//  index.phpで次のように使用します
//  $MenuBar_Right = array('menu_pagename'=>'MenuBar-Right'
//               , 'source_html_tag' => array('head'=>'<b>head</b>', 'foot'=>'<b>foot</b>')
//                      );
if ( isset($MenuBar_Right) && is_array($MenuBar_Right) )
{
    $menu_r = array('','','');
    $tmp_key = 'source_html_tag';
    if (isset($MenuBar_Right['menu_pagename']))
            $tmp_menu_r_pname = trim((string) $MenuBar_Right['menu_pagename']);
        else
            $tmp_menu_r_pname = '';
    // header
    if (isset($MenuBar_Right[$tmp_key]) && isset($MenuBar_Right[$tmp_key]['head']))
        $menu_r[0] = (string) $MenuBar_Right[$tmp_key]['head'];
    // footer
    if (isset($MenuBar_Right[$tmp_key]) && isset($MenuBar_Right[$tmp_key]['foot']))
        $menu_r[2] = (string) $MenuBar_Right[$tmp_key]['foot'];
    // body
    if ( $tmp_menu_r_pname !== '' )
    {
       if ( !isset($vars['page']) || ($vars['page'] !== $tmp_menu_r_pname) )
       if (arg_check('read') && exist_plugin_convert('include'))
            $menu_r[1] = do_plugin_convert('include', $tmp_menu_r_pname.',notitle' );
    }
    $menu2 = implode($menu_r);
}

// ------------------------------------------------------------
// Output

// HTTP headers
pkwk_common_headers();
header('Cache-control: no-cache');
header('Pragma: no-cache');
header('Content-Type: text/html; charset=' . CONTENT_CHARSET);

// HTML DTD, <html>, and receive content-type
if (isset($pkwk_dtd)) {
	$meta_content_type = pkwk_output_dtd($pkwk_dtd);
} else {
	$meta_content_type = pkwk_output_dtd();
}

?>
<head>
 <?php echo $meta_content_type ?>
 <meta http-equiv="content-style-type" content="text/css" />
<?php if ($nofollow || ! $is_read)  { ?> <meta name="robots" content="NOINDEX,NOFOLLOW" /><?php } ?>
<?php if (PKWK_ALLOW_JAVASCRIPT && isset($javascript)) { ?> <meta http-equiv="Content-Script-Type" content="text/javascript" /><?php } ?>

 <title><?php echo $title ?> - <?php echo $page_title ?></title>

 <link rel="SHORTCUT ICON" href="<?php echo $image['favicon'] ?>" />
 <?php
        $css_uri       = SKIN_DIR . "popowiki.css.php?charset=" . $css_charset;
        $css_print_uri = $css_uri . "&amp;media=print";
        if ( defined('POPO_STYLE_H_INDEX') )
        {
            $css_uri       .= "&amp;style=".  urlencode(POPO_STYLE_H_INDEX);
            $css_print_uri .= "&amp;style=".  urlencode(POPO_STYLE_H_INDEX);
        }
 ?>
 <link rel="stylesheet" type="text/css" media="screen" href="<?php echo $css_uri ?>" charset="<?php echo $css_charset ?>" />
 <link rel="stylesheet" type="text/css" media="print"  href="<?php echo $css_print_uri ?>" charset="<?php echo $css_charset ?>" />
 <link rel="alternate" type="application/rss+xml" title="RSS" href="<?php echo $link['rss'] ?>" /><?php // RSS auto-discovery ?>

<?php echo $head_tag ?>
<script type="text/javascript">
<!--
  function display_child_ul(obj , flag)
  {
      if (obj == null) { return 0; }
      for (var i = 0, len = obj.length; i < len; i++)
      {
         if (obj[i].nodeName == 'UL')
         {
            obj[i].style.display = (flag == 'on') ? "block" : "none";
         }
      }
     return 0;
  }
// -->
</script>
</head>
<body>
<?php
// header

    $img_attr = array();
    if (isset($_IMAGE_SIZE['skin']['logo'][0]))
        $img_attr[] = 'width="' . $_IMAGE_SIZE['skin']['logo'][0] . '"';
    if (isset($_IMAGE_SIZE['skin']['logo'][1]))
        $img_attr[] = 'height="' . $_IMAGE_SIZE['skin']['logo'][1] . '"';

    if ( count($page_title) > 0)
    {
        $img_attr[] = 'alt="'   . HtmlUtils::escapeHTML($page_title) . '"';
        $img_attr[] = 'title="' . HtmlUtils::escapeHTML($page_title) . '"';
    }
    $img_attr = implode(" ", $img_attr);
    $img = sprintf('<img id="logo" src="%s" %s />' , IMAGE_DIR . $image['logo'] , $img_attr );

    $top_logo = sprintf('<a href="%s">%s</a>' , $link['top'] , $img);
    unset($img_attr, $img);


//   define('OUTPUT_SIMPLE_MENU', 1); // debug
   $navigator = "";
// local var scope on html.php function catbody : not global
   if(PKWK_SKIN_SHOW_NAVBAR)
   {
        function _add_linklist_from_global_link(&$lists , $key, $value = '', $javascript = '')
        {
            $lang = & $GLOBALS['_LANG']['skin'];
            $link = & $GLOBALS['_LINK'];
            if (! isset($lang[$key])) { if ($value === '') $value = $key; }
            if (! isset($link[$key])) { $lists[] = 'LINK NOT FOUND'; return FALSE; }
            if (! PKWK_ALLOW_JAVASCRIPT) $javascript = '';

            if (!isset($lists) || is_null($lists))
            {
                $lists = array();
            }
            $lists[] =  sprintf('<a href="%s" %s>%s</a>' ,
                                $link[$key] ,
                                $javascript ,
                                (($value === '') ? $lang[$key] : $value)
                                    );
            return TRUE;
        }

        function _make_navi_links($target_keys, $allow_keys = null)
        {
            $navi = array();

            $no_items =  array_diff($target_keys , ($allow_keys)? $allow_keys : $GLOBALS['navi_link_keys_for_user']);
            $keys = array_diff($target_keys , $no_items);

            if ( count($keys) < 1 )
               return array();

            $navi = array();
            foreach($keys as $key)
            {
               _add_linklist_from_global_link($navi ,  $key);
            }
            return $navi;
        }

        function _make_navi_normal($target_keys, $allow_keys = null)
        {
            $navi = _make_navi_links($target_keys, ($allow_keys)? $allow_keys : $GLOBALS['navi_link_keys_for_user']);

            if (count($navi) < 1)
                return '';

            return "[ " . implode(' | ', $navi) ." ]";
        }

        function _get_navi_all_items()
        {
            $items = array();
            $items['home'] = array('home');
            $items['edit'] = array('new','edit', 'freeze', 'unfreeze',
                           'diff', 'backup', 'file_uploads', 'upload',
                           'copy', 'rename', 'reload');
//            $items['view'] = array('reload');
            $items['search'] = array('search', 'list', 'filelist');
            $items['help'] = array('recent', 'help');

            $r = array();
            foreach($items as $key => $v)
            {
                $r[$key] = _make_navi_links($v);
            }

            return $r;
        }

        function _get_normal_menu()
        {
            $items = array();
            $items[] = array('home');
            $items[] = array('edit', 'freeze', 'unfreeze',
                           'diff', 'backup', 'file_uploads', 'upload', 'reload');
            $items[] = array('new', 'list', 'filelist', 'search', 'recent', 'help');
            $r = array();
            foreach ($items as $item)
               $r[] = _make_navi_normal($item);

            return implode(" &nbsp;", $r);
        }

        function _get_auto_menu()
        {
            $lang = & $GLOBALS['_LANG']['skin'];
            $parents = _get_navi_all_items();
            $ct = 0;
            $s = array();
            $s[] = '<div class="container_auto_menu">';
            $s[] = '<ul class="auto_menu">';

            foreach($parents as $key => $childs)
            {
                $item = array();
                foreach($childs as $link)
                  $item[] = "      <li>$link</li>";
                $k = (isset($lang['m_'.$key]) ? $lang['m_'.$key] : $key );
                if (count($item)>0)
                {
                    $uri = 'javascript:void(0);'; // href="javascript:void(0);" , href="#"
                    if ( ($key == 'home') && (isset($GLOBALS['_LINK'][$key])) )
                        $uri = $GLOBALS['_LINK'][$key];
                    $s[] = '<li'.
                           ' onmouseover="display_child_ul(this.childNodes,\'on\');"' .
                           ' onmouseout="display_child_ul(this.childNodes,\'off\');"' .
                           ' ><a href="' . $uri . '">'. $k .'</a>' . "\n" .
                           '<ul>' . implode("\n", $item) . "\n</ul>\n" .
                           '</li>';
                    $ct++;
                }
            }
            $s[] = '</ul>';
            $s[] = '</div>';

            if ($ct>0)
                return implode("\n", $s) . "\n";
            else
                return "";
        }

        if ( (!defined('OUTPUT_SIMPLE_MENU')) || (! OUTPUT_SIMPLE_MENU) )
        {
            $navigator = _get_auto_menu();
        }
        else
        {
            $navigator = _get_normal_menu();
        }
    } /* PKWK_SKIN_SHOW_NAVBAR */

    $header_item_custum = '';  // reserved
//    $header_item_custum = 'here : custum html source';
    $header_item_bookmarks = ''; // reserved
//    $header_item_bookmarks = '<div id="bookmarks">bookmarks</div>';
    $header_item_sitetitle = '';
    $header_item_title     = '';
    $header_item_pagelinks  = '';
    $header_item_automenu  = '';

    $header_item_sitetitle = '<h1 class="pagetitle">' . HtmlUtils::escapeHTML($page_title) . "</h1>\n";
    if (defined('SKIN_DEFAULT_TITLE_WITH_RELATED_LINK') && SKIN_DEFAULT_TITLE_WITH_RELATED_LINK)
    {
        $header_item_title = '<h1 class="title">' . $page . "</h1>\n";
    }
    else
    {
        $tmp_title = HtmlUtils::escapeHTML(strip_htmltag($page));
        if ( ($is_page) && isset($link['reload']) )
            $tmp_title = sprintf('<a href ="%s">%s</a>', $link['reload'] , $tmp_title);
        $header_item_title = '<h1 class="title">' . $tmp_title . "</h1>\n";
    }

    if ($is_page) 
      { 
          if(SKIN_DEFAULT_DISABLE_TOPICPATH)
          {
              if (defined('SKIN_DEFAULT_SHOW_LINK_PATH') && SKIN_DEFAULT_SHOW_LINK_PATH)
              {
                $header_item_pagelinks = sprintf('<a href="%s" ><span class="small">%s</span></a>' , $link['reload'],  $link['reload']);
              }
          }
          else
          {
              $header_item_pagelinks = '<span class="small">';
              require_once(PLUGIN_DIR . 'topicpath.inc.php');
              $header_item_pagelinks .= plugin_topicpath_inline();
              $header_item_pagelinks .= '</span>'. "\n";
          }
      } 

    if (defined('SKIN_DEFAULT_BODY_HEADER_CUSTUM_EREA') && SKIN_DEFAULT_BODY_HEADER_CUSTUM_EREA)
    {
        $header_item_custum = SKIN_DEFAULT_BODY_HEADER_CUSTUM_EREA . "\n";
    }

      // Auto Menu output
      if ( (!defined('OUTPUT_SIMPLE_MENU')) || (! OUTPUT_SIMPLE_MENU) )
      {
            $header_item_automenu = '<div id="navigator">' . "\n";
            $header_item_automenu .= $navigator . "\n";
            $header_item_automenu .= '</div>' . "\n";
      }

      $c1 = $header_item_sitetitle;
      $c2 = $header_item_title . "\n" . $header_item_pagelinks . "\n";

      $r1 = $header_item_custum;
      $r2 = $header_item_bookmarks . "\n" . $header_item_automenu;

    ?>

<div id="header">
<table cellpadding="2" cellspacing="2" border="0" width="100%">
    <tr>
        <td width="90px" height="90px" rowspan="2"><?php echo $top_logo ?></td>
        <td width="100%"><?php echo $c1; ?></td>
        <td width="380px" ><?php echo $r1; ?></td>
    </tr>
    <tr>
        <td><?php echo $c2; ?></td>
        <td><?php echo $r2; ?></td>
    </tr>
</table>
</div> <!-- /header -->
<?php
  if ( (defined('OUTPUT_SIMPLE_MENU')) && (OUTPUT_SIMPLE_MENU) )
  {
        echo '<div id="navigator">' . "\n";
        echo $navigator . "\n";
        echo '</div>' . "\n";
  }
?>

<?php echo $hr ?>

<?php
    if ( ($menu !== FALSE) || ($menu2 !== FALSE) )
    {
        $menu  = (isset($menu) ? (string) $menu : '');
        $menu2 = (isset($menu2) ? (string) $menu2 : '');
        $table = $td = array();

        // table left
        if ($menu !== '')
            $td[] = <<<ENDTEXT
  <td class="menubar">
   <div id="menubar">{$menu}</div>
  </td>
ENDTEXT;

        // table center
            $td[] = <<<ENDTEXT
  <td valign="top">
   <div id="body">{$body}</div>
  </td>
ENDTEXT;

        // table right
         if ($menu2 !== '')
            $td[] = <<<ENDTEXT
  <td class="menubar">
   <div id="menubar2">{$menu2}</div>
  </td>
ENDTEXT;

        $td = implode($td);
        $table = <<<ENDTEXT
<table border="0" style="width:100%">
 <tr>
{$td}
 </tr>
</table>
ENDTEXT;

        // output table
        echo $table;
    } else { ?>
<div id="body"><?php echo $body ?></div>
<?php } ?>

<?php if ($notes != '') { ?>
<div id="note"><?php echo $notes ?></div>
<?php } ?>

<?php if ($attaches != '') { ?>
<div id="attach">
<?php echo $hr ?>
<?php echo $attaches ?>
</div>
<?php } ?>

<?php echo $hr ?>

<?php
if (PKWK_SKIN_SHOW_TOOLBAR)
{
    global $_IMAGE_SIZE;
    if (!isset($_IMAGE_SIZE))
        $_IMAGE_SIZE = array();
    if (!isset($_IMAGE_SIZE['skin']))
        $_IMAGE_SIZE['skin'] = array();

    // Set toolbar-specific images
    $_IMAGE['skin']['reload']   = 'reload.png';
    $_IMAGE['skin']['new']      = 'new.png';
    $_IMAGE['skin']['edit']     = 'edit.png';
    $_IMAGE['skin']['freeze']   = 'freeze.png';
    $_IMAGE['skin']['unfreeze'] = 'unfreeze.png';
    $_IMAGE['skin']['diff']     = 'diff.png';
    $_IMAGE['skin']['upload']   = 'file.png';
    $_IMAGE['skin']['copy']     = 'copy.png';
    $_IMAGE['skin']['rename']   = 'rename.png';
    $_IMAGE['skin']['top']      = 'top.png';
    $_IMAGE['skin']['list']     = 'list.png';
    $_IMAGE['skin']['search']   = 'search.png';
    $_IMAGE['skin']['recent']   = 'recentchanges.png';
    $_IMAGE['skin']['backup']   = 'backup.png';
    $_IMAGE['skin']['help']     = 'help.png';
    $_IMAGE['skin']['rss']      = 'rss.png';
    $_IMAGE['skin']['rss10']    = & $_IMAGE['skin']['rss'];
    $_IMAGE['skin']['rss20']    = 'rss20.png';
    $_IMAGE['skin']['rdf']      = 'rdf.png';

    $_IMAGE_SIZE['skin']['rss']   = array(36, 14);
    $_IMAGE_SIZE['skin']['rss10'] = array(36, 14);
    $_IMAGE_SIZE['skin']['rss20'] = array(54, 14);
    $_IMAGE_SIZE['skin']['rdf']   = array(36, 14);
    $_IMAGE_SIZE['skin']['atom']  = array(36, 14);

    function _toolbar($key, $x = 20, $y = 20)
    {
        $lang  = & $GLOBALS['_LANG']['skin'];
        $link  = & $GLOBALS['_LINK'];
        $image = & $GLOBALS['_IMAGE']['skin'];
        if (! isset($lang[$key]) ) { echo 'LANG NOT FOUND';  return FALSE; }
        if (! isset($link[$key]) ) { echo 'LINK NOT FOUND';  return FALSE; }
        if (! isset($image[$key])) { echo 'IMAGE NOT FOUND'; return FALSE; }

        $image_size = & $GLOBALS['_IMAGE_SIZE']['skin'];
        if (isset($image_size[$key]))
        {
            $x = (string) $image_size[$key][0];
            $y = (string) $image_size[$key][1];
        }

        echo '<a href="' . $link[$key] . '">' .
            '<img src="' . IMAGE_DIR . $image[$key] . '" width="' . $x . '" height="' . $y . '" ' .
                'alt="' . $lang[$key] . '" title="' . $lang[$key] . '" />' .
            '</a>';
        return TRUE;
    }

    echo "\n";
    echo "<!-- Toolbar -->\n";
    echo '<div id="toolbar">' . "\n";

    $toolbars = array();
    $toolbars[] = array('top');
    if ($is_page)
    {
        $toolbars[] = array('edit','freeze','unfreeze','diff','backup','upload',
                            'copy','rename','reload');
    }
    $toolbars[] = array('new','list','search','recent');
    $toolbars[] = array('help');
    $toolbars[] = array('rss10');

    $ct_p = 0;
    foreach($toolbars as $toolbar)
    {
        $ct_c = 0;
        foreach($toolbar as $v)
        {
           if ( in_array ($v , $navi_link_keys_for_user ))
           {
              if ( $ct_c == 0 )
              {
                  if ( $ct_p != 0 )
                     echo '&nbsp;&nbsp;&nbsp;';
                  $ct_p++;
              }
              else
                echo "&nbsp;";
              _toolbar($v);
              $ct_c++;
           }
        }
    }
       
    echo "</div>\n\n";

//    var_dump(array_diff(array_keys($_LINK), $navi_link_keys_for_user)); // for debug

} // PKWK_SKIN_SHOW_TOOLBAR

// OUTPUT_HIDE_LASTMODIFIED = FALSE
if ( (! defined('OUTPUT_HIDE_LASTMODIFIED')) || (! OUTPUT_HIDE_LASTMODIFIED) )
{
    if ($lastmodified != '')
        echo '<div id="lastmodified">Last-modified: '. $lastmodified .'</div>'."\n";
}

if ($related != '')
{
    echo '<div id="related">Link: ' . $related . '</div>'."\n";
}

// footer
    echo "\n<div id=\"footer\">\n";

    // Site administrator
    printf('    Site administrator: <a href="%s">%s</a><p />'."\n" , $modifierlink , $modifier);

    // hr
    echo '    <hr style="border-style: dotted; border-color: #CCFFCC; padding: 1">'."\n";

    $s = array( 'h' => array() , 'b' => array() , 'f' => array() );
    $s['h'][] = '<div style="text-align: right; float:right; font-size: xx-small">';
    $s['f'][] = '</div>';

    // OUTPUT_HIDE_CORE_POWERDBY = FALSE
    if ( (! defined('OUTPUT_HIDE_CORE_POWERDBY')) || (! OUTPUT_HIDE_CORE_POWERDBY) )
        $s['b'][] = S_COPYRIGHT;
    
    // HIDE_VERSION_STRING = FALSE
    if ( (! defined('HIDE_VERSION_STRING')) || (! HIDE_VERSION_STRING ))
      $s['b'][] = "<br />\n Powered by PHP " . PHP_VERSION;

    if (count($s['b'])>0)
    {
        foreach( array('h','b','f') as $k )
        {
            echo "    " . implode("\n", $s[$k]) . "\n";
        }
    }

  // OUTPUT_HIDE_CONVERT_TIME = FALSE
  if ( (! defined('OUTPUT_HIDE_CONVERT_TIME')) || (! OUTPUT_HIDE_CONVERT_TIME) )
  {
     echo '    <div style="text-align: left; font-size: small">HTML convert time: ';
     echo elapsedtime();
     echo " sec. </div>\n";
  }
?>
</div>
</body>
</html>