<?php

// PukiWiki - Yet another WikiWikiWeb clone
// $Id: versionlist.inc.php,v 1.22 2011/01/25 15:01:01 henoheno Exp $
// Copyright (C)
//	 2002-2007 PukiWiki Developers Team
//	 2002      S.YOSHIMURA GPL2 yosimura@excellence.ac.jp
// License: GPL v2
//
// Listing files, with CVS/RCS/SVN revisions and commit-dates from '$Id' keywords
/**/


function plugin_versionlist_action()
{
    global $_title_versionlist;

    if ( PKWK_SAFE_MODE )
        die_message('PKWK_SAFE_MODE prohibits this');

    if ( defined(HIDE_VERSION_STRING) && HIDE_VERSION_STRING )
        die_message('HIDE_VERSION_STRING prohibits this');

    return array(
        'msg' => $_title_versionlist,
        'body' => plugin_versionlist_convert());
}

function plugin_versionlist_convert()
{
    if ( PKWK_SAFE_MODE )
        return ''; // Show nothing

    if ( defined(HIDE_VERSION_STRING) && HIDE_VERSION_STRING )
        return ''; // Show nothing

//    $warn_msg = basename(__FILE__) .' : will be removed in nearly future';
//    trigger_error($warn_msg , E_USER_NOTICE); // E_USER_NOTICE E_USER_DEPRECATED

    return plugin_versionlist_get_converted_data();
}

function plugin_versionlist_get_converted_data()
{
    if ( PKWK_SAFE_MODE )
        return ''; // Show nothing

    static $call_count;
    $call_count = (int) $call_count + 1;

    if ( $call_count > 1 )
    {
        return '';
    }

    // Directories to scan
    $scan['.'] = NULL;
    $scan[LIB_DIR] = NULL;
    $scan[DATA_HOME] = NULL;
    $scan[PLUGIN_DIR] = NULL;
    $scan[SKIN_DIR] = NULL;

    $row = $matches = array();
    foreach ( array_keys($scan) as $sdir )
    {
        if ( !$dir = @dir($sdir) )
            continue;
        if ( $sdir == '.' )
            $sdir = '';
        while ( FALSE !== ($file = $dir->read()) )
        {
            if ( !preg_match('/\.(?:php|css|js)$/i', $file) )
                continue;
            $path = $sdir . $file;
            $row[$path] = array();
            $data = join('', file($path));
            if ( preg_match('#\$' . 'Id: .+ (\d+(?:\.\d+)*) (\d{4}[/-]\d{2}[/-]\d{2} \d{2}:\d{2}:\d{2}[^ ]*) (.+) E.+\$#', $data, $matches) )
            {
                $row[$path]['rev'] = $matches[1]; // "1", "1.23" or "1.23.45.6"
                $row[$path]['date'] = $matches[2];
                $row[$path]['author'] = trim((string) $matches[3]);
            }
        }
        $dir->close();
    }
    if ( empty($row) )
        return '';
    unset($data);

    ksort($row, SORT_STRING);

    $retval = array();
    $retval[] = <<<EOD
<table border="1">
 <thead>
  <tr>
   <th>File</th>
   <th>Revision</th>
   <th>Date</th>
   <th>author</th>
  </tr>
 </thead>
 <tbody>
EOD;

    foreach ( array_keys($row) as $path )
    {
        $file = HtmlUtils::escapeHTML($path);
        $rev = isset($row[$path]['rev']) ? HtmlUtils::escapeHTML($row[$path]['rev']) : '';
        $date = isset($row[$path]['date']) ? HtmlUtils::escapeHTML($row[$path]['date']) : '';
        $author = count($row[$path]['author']) ? HtmlUtils::escapeHTML($row[$path]['author']) : '';
        $retval[] = <<<EOD
  <tr>
   <td>$file</td>
   <td align="right">$rev</td>
   <td>$date</td>
   <td>$author</td>
  </tr>
EOD;
        unset($row[$path]);
    }

    $retval[] = <<<EOD
 </tbody>
</table>
EOD;

    return implode("\n", $retval);
}
