/**
	PlayListMaker Software to create a playlist for Android devices.
	Copyright (C) 2013 KuroBlack.

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


package playlistmaker.application;


import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import playlistmaker.command.Command;
import playlistmaker.command.DeleteCommand;
import playlistmaker.command.PropertyCommand;

public class ContextMenu {

	JPopupMenu popupmenu;
	
	public ContextMenu(final Application app, JPopupMenu popup){
		popupmenu = popup;

		/*アクションリスナー ここで機能を追加する*/
		addPopupMenuItem("削除", new ActionListener(){ 
			public void actionPerformed(ActionEvent ae){
				Command c = new DeleteCommand(app);
				c.execute();
			}
		});
		/*ここまででひとつのアクションリスナー*/
		addPopupMenuItem("プロパティ", new ActionListener(){ 
			public void actionPerformed(ActionEvent ae){
				Command c = new PropertyCommand(app);
				c.execute();
			}
		});
	}

	/*メニュー項目を作成する*/
	private JMenuItem addPopupMenuItem(String name, ActionListener al){
	    JMenuItem item = new JMenuItem(name);
	    item.addActionListener(al);
	    popupmenu.add(item);
	    return item;
	  }

}
