/**
	PlayListMaker Software to create a playlist for Android devices.
	Copyright (C) 2013 KuroBlack.

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package playlistmaker.dialog;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import playlistmaker.application.Application;
import playlistmaker.configmgr.SettingConfig;

public class SettingDialog extends JDialog {
	
	private Application app;
	private JList<String> list = new JList<String>();
	private DefaultListModel<String> listModel = new DefaultListModel<String>();
	private SettingConfig sc;

	public SettingDialog(JFrame parent, boolean modal) {
		super(parent, modal);
		
		// 親ウィンドウ(app)の取得
		app = (Application) parent;
		// 構成設定情報の取得
		sc = app.getConfig();
		view();
	}

	// OKボタンクリック時の処理
	private void ok() {
		// リストが選択されているなら，選択項目の値を構成設定に保存
		if (list.getSelectedIndex() >= 0) {
			String Path = listModel.get(list.getSelectedIndex());
			sc.addRootPath(Path);

			//System.out.println(Path);
			this.dispose();
		}
	}
	
	// キャンセルボタンクリック時の処理
	private void cancel() {
		// 終了
		this.dispose();
	}
	
	// リストアイテムの追加
	private void addItem() {
		listModel.addElement("PC");
		listModel.addElement("/storage/sdcard0/external_sd");
		listModel.addElement("/storage/sdcard1");
		listModel.addElement("/storage/ext_sd");
		listModel.addElement("/mnt/sdcard");
		listModel.addElement("/mnt/sdcard/external_sd");
		listModel.addElement("/mnt/sdcard/ext_sd");
		listModel.addElement("/mnt/sdcard-ext");
		listModel.addElement("/mnt/sdcard/removable_sdcard");
		listModel.addElement("/mnt/extSdCard");
		listModel.addElement("/mnt/ext_card");
	}
	
	// 構成設定情報のルートパスと同じリスト項目の値を検索
	private int getRootPathIndex() {
		for (int i = 0; i < listModel.getSize(); i++) {
			if (listModel.get(i).equals(sc.getRootPath())) {
				return i;
			}
		}
		
		return 0;
	}
	
	// 画面表示処理
	private void view() {
		Container cp = getContentPane();
		cp.setLayout(new BoxLayout(cp, BoxLayout.Y_AXIS));

		// パネルを作り，そのパネルに対してレイアウトを設定する
		JPanel p1 = new JPanel();
		GridBagLayout layout = new GridBagLayout();
		p1.setLayout(layout);
		// フレームにこのパネルを追加する
		cp.add(p1);

		GridBagConstraints gbc = new GridBagConstraints();
		// 余白の設定
		gbc.insets = new Insets(5, 5, 5, 5);
		
		// (x, y) = (0, 0)に幅2，高さ1でラベルを表示
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth = 2;
		gbc.gridheight = 1;
		gbc.anchor = GridBagConstraints.WEST;
		JLabel explain = new JLabel("保存先を設定してください．");
		layout.setConstraints(explain, gbc);
		p1.add(explain);
		
		// (x, y) = (0, 1)に幅2, 高さ1でリストボックスを表示
		gbc.gridy = 1;
		gbc.anchor = GridBagConstraints.CENTER;
		// リストにリストデータを設定
		list.setModel(listModel);
		addItem();
		// デフォルトで選択されている項目の設定
		// 構成設定に保存されている項目を選択させる
		list.setSelectedIndex(getRootPathIndex());
		// スクロールバーをリストボックスに設定
		JScrollPane sp = new JScrollPane();
		sp.getViewport().setView(list);
		layout.setConstraints(sp, gbc);
		p1.add(sp);
		
		// (x, y) = (0, 2)に幅・高さ1でボタンを表示
		gbc.gridy = 2;
		gbc.gridwidth = 1;
		// 右側に寄せる
		gbc.anchor = GridBagConstraints.EAST;
		JButton ok = new JButton("OK(O)");
		// OKボタンのリスナー設定
		ok.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				// TODO 自動生成されたメソッド・スタブ
				ok();
			}
			
		});
		
		layout.setConstraints(ok, gbc);
		p1.add(ok);
		
		// (x, y) = (1, 2)に幅・高さ1でボタンを表示
		gbc.gridx = 1;
		// 左側に寄せる
		gbc.anchor = GridBagConstraints.WEST;
		JButton cancel = new JButton("Cancel(C)");
		// キャンセルボタンのリスナー設定
		cancel.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				// TODO 自動生成されたメソッド・スタブ
				cancel();
			}
			
		});
		layout.setConstraints(cancel, gbc);
		p1.add(cancel);
		
		setTitle("設定");
		setSize(250, 250);
        setLocationRelativeTo(null);	// 画面の中央に配置する
        setResizable(false);			// ウィンドウのリサイズを禁止する
		setVisible(true);
	}
}
