package playlistmaker.dialog;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

import playlistmaker.application.Application;
import playlistmaker.application.ListItem;

public class PropertyDialog  extends JDialog{

	private Application app;
	
	public PropertyDialog(JFrame parent, boolean modal) {
		super(parent, modal); /*AboutDialog の設定を使い プロパティ画面以外をいじれなくする*/		
		// TODO 自動生成されたコンストラクター・スタブ	
		this.app = (Application)parent;
		
		/*
		 * プロパティ画面
		 * 
		 * */
		
		JList list = app.getListBox(); /*リストボックスをゲットしてくる*/
		JPanel panel = new JPanel();	/*JPanelインスタンスを生成  主にラベルやボタンの表示などを行う*/
		//JFrame frame = new JFrame(filename+"のプロパティ");/*タイトルを設定してフレーム生成*/
		ListItem li = (ListItem) app.getdlModel().getElementAt(list.getSelectedIndex());  /*絶対パスを獲得してくる*/
		String filename = li.getName(); 
		setTitle(filename+"のプロパティ");
	
		setSize(200, 100);	/*フレームサイズ設定*/
		Container contentPane = getContentPane();
		contentPane.add(panel, BorderLayout.WEST);
	//	setResizable(false);                    // ウィンドウのリサイズを禁止する


		/*
		 * レイアウト
		 * */
		
		GridBagLayout gl = new GridBagLayout();/*レイアウト生成のための関数*/
        GridBagConstraints gbc = new GridBagConstraints(); /*コンテナ作成*/
        //gbc.fill = GridBagConstraints.HORIZONTAL; /*横幅自動調節*/
		panel.setLayout(gl);
	
		/*名前のレイアウト*/
		JLabel name = new JLabel("名前:");
		/*レイアウト設定*/
		gbc.gridx = 0;
		gbc.gridy = 0;
		gl.setConstraints(name,gbc);
		
		
		/*場所のレイアウト*/
		JLabel field = new JLabel("場所:");
		/*レイアウト設定*/
		gbc.gridx = 0;
		gbc.gridy = 1;
		gl.setConstraints(field,gbc);
		
		/*名前のテキストフィールドレイアウト*/
		JTextField nameF = new JTextField(""+filename ,20);		/*(テキストフィールド内のテキスト , 入力フィールドの幅)*/
		nameF.setHorizontalAlignment(JTextField.LEFT);		/*テキストフィールド内部の文字位置指定*/
		/*レイアウト設定*/
		gbc.gridx = 1;
		gbc.gridy = 0;
		gbc.gridwidth = 1;
		gl.setConstraints(nameF,gbc);

		
		/*PATHの獲得*/	
		JLabel path = new JLabel(""+li.getPath());
		//path.setPreferredSize(new Dimension(200, 50));
		/*レイアウト設定*/
		gbc.gridx = 1;
		gbc.gridy = 1;
		gbc.gridwidth = 2;
		gl.setConstraints(path,gbc);
		
		/*closeボタン*/
		JButton close = new JButton("閉じる");
		/*ボタンとその処理を設定*/
		close.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			setVisible(false);	/*クローズ処理*/
			}
		});
		/*レイアウト設定*/
		gbc.gridx = 1;
		gbc.gridy = 2;
		gbc.gridwidth = 1;
		gl.setConstraints(close,gbc);
		
		/*表示部分*/
		panel.add(name);
		panel.add(nameF);
		panel.add(field);
		panel.add(path);
		panel.add(close);
		setVisible(true);/*フレーム表示*/
		
	}

}
