/**
	PlayListMaker Software to create a playlist for Android devices.
	Copyright (C) 2013 KuroBlack.

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package playlistmaker.dialog;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;

public class AboutDialog extends JDialog implements ActionListener{
	
	public AboutDialog(JFrame parent, boolean modal) {
		super(parent, modal);

		Container cp = getContentPane();
		//cp.setLayout(new BoxLayout(cp, BoxLayout.Y_AXIS));
		
		JPanel p1 = new JPanel(); 
        GridBagLayout layout = new GridBagLayout(); 
        p1.setLayout(layout);
        cp.add(p1);
        
        GridBagConstraints gbc = new GridBagConstraints();
        
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.CENTER;
        
        JTabbedPane tab = new JTabbedPane();
        tab.setSize(395, 200);

        JPanel tab1 = new JPanel();
        tab1.setLayout(new BoxLayout(tab1, BoxLayout.Y_AXIS));

        JPanel tab2 = new JPanel();
        //tab2.setLayout(new BoxLayout(tab2, BoxLayout.Y_AXIS));
        tab2.setLayout(new BorderLayout());

		JLabel app = new JLabel();
		app.setAlignmentX(CENTER_ALIGNMENT);
		app.setText("PlayListMaker");
		app.setFont(new Font(getFont().getFontName(), Font.BOLD, 24));
		tab1.add(app);

		JLabel author = new JLabel();
		author.setAlignmentX(CENTER_ALIGNMENT);
		author.setText("author : KuroBlack");
		author.setFont(new Font(getFont().getFontName(), Font.PLAIN, 14));
		tab1.add(author);

		JLabel cr = new JLabel();
		cr.setAlignmentX(CENTER_ALIGNMENT);
		cr.setText("Copyright(c) 2013 KuroBlack.");
		cr.setFont(new Font(getFont().getFontName(), Font.PLAIN, 14));
		tab1.add(cr);
		
        JLabel url = new JLabel();
		url.setAlignmentX(CENTER_ALIGNMENT);
        url.setText("URL : http://sourceforge.jp/projects/playlistmaker/");
        url.setFont(new Font(getFont().getFontName(), Font.PLAIN, 12));
        tab1.add(url);

		JLabel li1 = new JLabel();
		li1.setAlignmentX(CENTER_ALIGNMENT);
		li1.setText("　　　　PlayListMakerの著作権は，日本国の著作権法および　　　　");
		li1.setFont(new Font(getFont().getFontName(), Font.PLAIN, 12));
		tab1.add(li1);

		JLabel li2 = new JLabel();
		li2.setAlignmentX(CENTER_ALIGNMENT);
		li2.setText("国際条約により保護されています．");
		li2.setFont(new Font(getFont().getFontName(), Font.PLAIN, 12));
		tab1.add(li2);

		//tab1.add(new JLabel("  "));

		JTextPane text = new JTextPane();
		File file = new File(getClass().getClassLoader().getResource("res/PlayListMaker-License.txt").getPath());
		try {
			BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file), "Shift-JIS"));
			StringBuilder sb = new StringBuilder();
			for(String line;(line=reader.readLine())!=null;) {
				sb.append(line + "\n");
			}
			
			text.setText(sb.toString());
			reader.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		JScrollPane scroll = new JScrollPane(text);
		scroll.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		text.setCaretPosition(0);
		text.setEditable(false);
		tab2.add(scroll, BorderLayout.CENTER);
		
        tab.addTab("バージョン(V)",tab1);
        tab.addTab("ライセンス(L)", tab2);
        
        tab.setMnemonicAt(0, KeyEvent.VK_V);
        tab.setMnemonicAt(1, KeyEvent.VK_L);

        layout.setConstraints(tab, gbc);
        p1.add(tab);

        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.CENTER;
        
        JButton ok_btn = new JButton("OK(O)");
		ok_btn.setMnemonic('O');
		ok_btn.setFont(new Font(getFont().getFontName(), Font.PLAIN, 12));
		ok_btn.addActionListener(this);
		ok_btn.setActionCommand("OK");
		ok_btn.setAlignmentX(CENTER_ALIGNMENT);
		layout.setConstraints(ok_btn, gbc);
		p1.add(ok_btn);
		
		

		setTitle("バージョン情報");
		setSize(400, 240);
        setLocationRelativeTo(null);	// 画面の中央に配置する
        setResizable(false);			// ウィンドウのリサイズを禁止する
		setVisible(true);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		String cmd = e.getActionCommand();

		if (cmd.equals("OK")) {
			this.dispose();
		}
	}

}
