/**
	PlayListMaker Software to create a playlist for Android devices.
	Copyright (C) 2013 KuroBlack.

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package playlistmaker.application;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

public class ListBox extends JPanel implements MouseListener{

	Application app;
	JList list;
	//JPopupMenu popup = new JPopupMenu();
	ContextMenu popup;
	
	public ListBox(final Application app) {
		this.app = app;

		this.setLayout(new BorderLayout());

		list = new JList();
		list.setModel(app.getdlModel());
		list.getSelectionModel().setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		list.setTransferHandler(new ListItemTransferHandler());
		list.setDropMode(DropMode.INSERT);
		list.setDragEnabled(true);

		JScrollPane sp = new JScrollPane();
		sp.getViewport().setView(list);
		this.add(sp, BorderLayout.CENTER);
		
		/*マウスリスナー登録*/
		list.addMouseListener(this);
		/*コンテキストメニュー作成*/
		popup = new ContextMenu(app);
		
	}
	/*JLisetオーバーライド*/
	public JList getListBox() {
		return list;
	}
	/*マウスリスナの挙動チェック*/
	private void mChek(MouseEvent mlistener) {
		// TODO 自動生成されたメソッド・スタブ
		if (mlistener.isPopupTrigger() && (list.getSelectedIndex() != -1)) { /*選択されているなら*/
			list.setSelectedIndex(list.locationToIndex(mlistener.getPoint())); 
			popup.show(mlistener.getComponent(), mlistener.getX(), mlistener.getY());
		}
	}
	
	/*マウスリスナー マウスの挙動に合わせた動き*/
	@Override
	public void mouseClicked(MouseEvent mlistener) {}
	@Override
	public void mouseEntered(MouseEvent mlistener) {}
	@Override
	public void mouseExited(MouseEvent mlistener) {}
	
	@Override
	public void mousePressed(MouseEvent mlistener) {
		// TODO 自動生成されたメソッド・スタブ
		mChek(mlistener);
	}
	@Override
	public void mouseReleased(MouseEvent mlistener) {
		// TODO 自動生成されたメソッド・スタブ
		mChek(mlistener);
	}

}
