/*
 * Created on 2007/09/27
 *
 * Copyright (C) 2005- Monami software, LP.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package jp.pizzafactory.debug.core;

import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MICommand;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.command.MITargetDownload;
import org.eclipse.cdt.debug.mi.core.command.MITargetSelect;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.runtime.Preferences;

public class HalfBakedSession {
	private Session session;
	private final int launchTimeout;
	private boolean isCallLoad;
	private String gdbinit;
	
	HalfBakedSession(Session session) {
		this.session  = session;
		Preferences prefs = CorePlugin.getDefault().getPluginPreferences();
		launchTimeout = prefs.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
	}
	
	public Session getSession() {
		return session;
	}
	
	public void postMICommands(MICommand[] commands) throws MIException {
		ICDITarget[] targets = session.getTargets();
		for (int j = 0; j < targets.length; j++) {
			Target target = (Target)targets[j];
			MISession miSession = target.getMISession();
			for (int i = 0; i < commands.length; i++) {
				MICommand command = commands[i];
				miSession.postCommand(command, launchTimeout);
				MIInfo info = command.getMIInfo();
				if (info == null) {
					throw new MIException(CorePlugin.getResourceString("src.common.No_answer")); //$NON-NLS-1$
				}
			}
			miSession.getMIInferior().update();
		}
		
	}
	
	public void setTCPSession(String type, String host, String port) throws MIException {

		String remote = host + ":" + port; //$NON-NLS-1$
		ICDITarget[] targets = session.getTargets();
		for (int i = 0; i < targets.length; ++i) {
			Target target = (Target)targets[i];
			MISession miSession = target.getMISession();
			CommandFactory factory = miSession.getCommandFactory();
			String miVersion = factory.getMIVersion();
			MITargetSelect select = factory.createMITargetSelect(new String[] {type, remote});
			miSession.postCommand(select, launchTimeout);
			MIInfo info = select.getMIInfo();
			if (info == null) {
				throw new MIException(CorePlugin.getResourceString("src.common.No_answer")); //$NON-NLS-1$
			}
			initAndLoad(session, miVersion);
			miSession.getMIInferior().update();
		}
	}
	
	public void setTCPSession(String host, String port) throws MIException {
		setTCPSession("remote", host, port);  //$NON-NLS-1$
	}
	
	public void setSerialSession(String device, String baudrate) throws MIException {
		ICDITarget[] targets = session.getTargets();
		for (int i = 0; i < targets.length; ++i) {
			Target target = (Target)targets[i];
			MISession miSession = target.getMISession();
			CommandFactory factory = miSession.getCommandFactory();
			String miVersion = factory.getMIVersion();
			MIGDBSet setRemoteBaud = factory.createMIGDBSet(new String[]{"remotebaud", baudrate}); //$NON-NLS-1$
			// Set serial line parameters
			miSession.postCommand(setRemoteBaud, launchTimeout);
			MITargetSelect select = factory.createMITargetSelect(new String[] {"remote", device}); //$NON-NLS-1$
			miSession.postCommand(select, launchTimeout);
			initAndLoad(session, miVersion);
			miSession.getMIInferior().update();
		}
	}
	
	public void setSimSession() throws MIException {
		ICDITarget[] targets = session.getTargets();
		for (int i = 0; i < targets.length; ++i) {
			Target target = (Target)targets[i];
			MISession miSession = target.getMISession();
			CommandFactory factory = miSession.getCommandFactory();
			String miVersion = factory.getMIVersion();
			MITargetSelect select = factory.createMITargetSelect(new String[] {"sim"}); //$NON-NLS-1$
			miSession.postCommand(select, launchTimeout);
			initAndLoad(session, miVersion);
			miSession.getMIInferior().update();
		}
	}

	private void initAndLoad(Session session, String miVersion) throws MIException {
		Preferences prefs = CorePlugin.getDefault().getPluginPreferences();
		int launchTimeout = prefs.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);

		ICDITarget[] targets = session.getTargets();
		for (int i = 0; i < targets.length; ++i) {
			Target target = (Target)targets[i];
			MISession miSession = target.getMISession();
			MISourceCommand source = new MISourceCommand(miVersion, gdbinit);
			miSession.postCommand(source, launchTimeout);
			MIInfo info = source.getMIInfo();
			if (info == null) {
				throw new MIException(CorePlugin.getResourceString("src.common.No_answer")); //$NON-NLS-1$
			}
			if (isCallLoad) {
				MITargetDownload download = new MITargetDownload(miVersion);
				miSession.postCommand(download, launchTimeout);
				info = source.getMIInfo();
				if (info == null) {
					throw new MIException(CorePlugin.getResourceString("src.common.No_answer")); //$NON-NLS-1$
				}
			}
		}

	}

	public void setLoad(boolean isCallLoad) {
		this.isCallLoad = isCallLoad;
	}
	
	public void setGdbinit(String gdbinit) {
		this.gdbinit = gdbinit;
	}

}
