/*
 * Created on 2007/02/09
 *
 * Copyright (C) 2005- Monami software, LP.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package jp.pizzafactory.crosschains.managedbuild.ui;

import java.io.IOException;
import java.net.URL;

import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageData;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedCProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.osgi.framework.Bundle;

public class WizardSelectSampleOperation implements Runnable {
	private final String PAGE_ID = "jp.pizzafactory.crosschains.managedbuild.ui.wizardPage"; //$NON-NLS-1$
	private static final String ATTR_FILE = "file"; //$NON-NLS-1$
	private static final String ATTR_PATH = "path"; //$NON-NLS-1$
	
	public void run() {
		MBSCustomPageData pageData = MBSCustomPageManager.getPageData(PAGE_ID);
		IWizardPage wizardPage = pageData.getWizardPage();
		WizardSelectSamplePage page = (WizardSelectSamplePage) wizardPage;
		IWizard wizard = page.getWizard();
		NewManagedCProjectWizard wiz = (NewManagedCProjectWizard)wizard;
		IProject newProject = wiz.getNewProject();
		
		Object obj = MBSCustomPageManager.getPageProperty(WizardSelectSamplePage.PAGE_ID, WizardSelectSamplePage.ELEMENT);
		if (!(obj instanceof IConfigurationElement)) {
			return;
		}
		
		IConfigurationElement element = (IConfigurationElement)obj;
		IConfigurationElement[] fileElements = element.getChildren();
		
		String contributorName = element.getContributor().getName();
		Bundle bundle = Platform.getBundle(contributorName);
		for (int i = 0; i < fileElements.length; i++) {
			if (fileElements[i].getName().equals(ATTR_FILE)) {
				String pathName = fileElements[i].getAttribute(ATTR_PATH);				
				Path srcPath = new Path(pathName);
				String dstPathName = srcPath.lastSegment();
				URL url = FileLocator.find(bundle, srcPath, null);
				if (url != null) {
					try {
						newProject.getFile(dstPathName).create(url.openStream(), true, null);
					} catch (CoreException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				} else {
					// TODO handle error.
				}
			}
		}
	}
}
