/*
 * Created on 2006/08/16
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.pizzafactory.core.win32;

import java.io.IOException;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import jp.pizzafactory.core.IPathConverter;

public class PathConverter implements IPathConverter {
	static {
		System.loadLibrary("PathConverter"); //$NON-NLS-1$
	}
	
	public static String _asShort(Bundle bundle, String pathName) {
		String path = null;
		try {
			Path pathObject = new Path(pathName);
			java.net.URL url = FileLocator.find(bundle, pathObject, null);
			if (url != null) {
				url = FileLocator.toFileURL(url);
				path = url.getPath().substring(1);
				path = toShortPath(path);
			}
		} catch (IOException e) {
			path = null;
		}
		
		return path;
	}
	
	private static native String toShortPath(String longName);

	public String asShort(Bundle bundle, String pathName) {
		return _asShort(bundle, pathName);
	}
	
	public String asShort(String pathName) {
		return toShortPath(pathName);
	}
}
