/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherBox;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.EngineArgs;
import com.sun.net.ssl.internal.ssl.EngineOutputRecord;
import com.sun.net.ssl.internal.ssl.MAC;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import javax.net.ssl.SSLEngineResult;
import sun.misc.HexDumpEncoder;

final class EngineWriter {
    private LinkedList outboundList = new LinkedList();
    private boolean outboundClosed = false;
    private static final Debug debug = Debug.getInstance("ssl");

    EngineWriter() {
    }

    private SSLEngineResult.HandshakeStatus getOutboundData(ByteBuffer byteBuffer) {
        Object e = this.outboundList.removeFirst();
        assert (e instanceof ByteBuffer);
        ByteBuffer byteBuffer2 = (ByteBuffer)e;
        assert (byteBuffer.remaining() >= byteBuffer2.remaining());
        byteBuffer.put(byteBuffer2);
        if (this.hasOutboundDataInternal()) {
            e = this.outboundList.getFirst();
            if (e == SSLEngineResult.HandshakeStatus.FINISHED) {
                this.outboundList.removeFirst();
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return null;
    }

    synchronized void writeRecord(EngineOutputRecord engineOutputRecord, MAC mAC, CipherBox cipherBox) throws IOException {
        if (this.outboundClosed) {
            throw new IOException("writer side was already closed.");
        }
        engineOutputRecord.write(mAC, cipherBox);
        if (engineOutputRecord.isFinishedMsg()) {
            this.outboundList.addLast(SSLEngineResult.HandshakeStatus.FINISHED);
        }
    }

    private void dumpPacket(EngineArgs engineArgs, boolean bl) {
        try {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            ByteBuffer byteBuffer = engineArgs.netData.duplicate();
            int n = byteBuffer.position();
            byteBuffer.position(n - engineArgs.deltaNet());
            byteBuffer.limit(n);
            System.out.println("[Raw write" + (bl ? "" : " (bb)") + "]: length = " + byteBuffer.remaining());
            hexDumpEncoder.encodeBuffer(byteBuffer, (OutputStream)System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized SSLEngineResult.HandshakeStatus writeRecord(EngineOutputRecord engineOutputRecord, EngineArgs engineArgs, MAC mAC, CipherBox cipherBox) throws IOException {
        if (this.hasOutboundDataInternal()) {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.getOutboundData(engineArgs.netData);
            if (debug != null && Debug.isOn("packet")) {
                this.dumpPacket(engineArgs, true);
            }
            return handshakeStatus;
        }
        if (this.outboundClosed) {
            throw new IOException("The write side was already closed");
        }
        engineOutputRecord.write(engineArgs, mAC, cipherBox);
        if (debug != null && Debug.isOn("packet")) {
            this.dumpPacket(engineArgs, false);
        }
        return null;
    }

    void putOutboundData(ByteBuffer byteBuffer) {
        this.outboundList.addLast(byteBuffer);
    }

    synchronized void putOutboundDataSync(ByteBuffer byteBuffer) throws IOException {
        if (this.outboundClosed) {
            throw new IOException("Write side already closed");
        }
        this.outboundList.addLast(byteBuffer);
    }

    private boolean hasOutboundDataInternal() {
        return this.outboundList.size() != 0;
    }

    synchronized boolean hasOutboundData() {
        return this.hasOutboundDataInternal();
    }

    synchronized boolean isOutboundDone() {
        return this.outboundClosed && !this.hasOutboundDataInternal();
    }

    synchronized void closeOutbound() {
        this.outboundClosed = true;
    }
}

