/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.text.BreakIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class InlineView
extends LabelView {
    private boolean nowrap;
    private AttributeSet attr;
    private float longestWordSpan = -1.0f;

    public InlineView(Element element) {
        super(element);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, shape, viewFactory);
        this.longestWordSpan = -1.0f;
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, shape, viewFactory);
        this.longestWordSpan = -1.0f;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.longestWordSpan = -1.0f;
        this.preferenceChanged(null, true, true);
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    public int getBreakWeight(int n, float f, float f2) {
        if (this.nowrap) {
            return 0;
        }
        return super.getBreakWeight(n, f, f2);
    }

    public View breakView(int n, int n2, float f, float f2) {
        InlineView inlineView = (InlineView)super.breakView(n, n2, f, f2);
        if (inlineView != this) {
            inlineView.longestWordSpan = -1.0f;
        }
        return inlineView;
    }

    float getLongestWordSpan() {
        if (this.longestWordSpan < 0.0f) {
            this.longestWordSpan = this.calculateLongestWordSpan();
        }
        return this.longestWordSpan;
    }

    float calculateLongestWordSpan() {
        float f = 0.0f;
        Document document = this.getDocument();
        String string = "multiByte";
        f = document != null && Boolean.TRUE.equals(document.getProperty(string)) ? this.calculateLongestWordSpanUseBreakIterator() : this.calculateLongestWordSpanUseWhitespace();
        return f;
    }

    float calculateLongestWordSpanUseBreakIterator() {
        float f = 0.0f;
        Document document = this.getDocument();
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        if (n2 > n) {
            try {
                FontMetrics fontMetrics = this.getFontMetrics();
                Segment segment = new Segment();
                document.getText(n, n2 - n, segment);
                Container container = this.getContainer();
                BreakIterator breakIterator = container != null ? BreakIterator.getLineInstance(container.getLocale()) : BreakIterator.getLineInstance();
                breakIterator.setText(segment);
                int n3 = breakIterator.first();
                int n4 = breakIterator.next();
                while (n4 != -1) {
                    if (n4 > n3) {
                        f = Math.max(f, (float)fontMetrics.charsWidth(segment.array, n3, n4 - n3));
                    }
                    n3 = n4;
                    n4 = breakIterator.next();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return f;
    }

    float calculateLongestWordSpanUseWhitespace() {
        float f = 0.0f;
        Document document = this.getDocument();
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        if (n2 > n) {
            try {
                int n3;
                Segment segment = new Segment();
                document.getText(n, n2 - n, segment);
                boolean bl = false;
                int n4 = n3 = segment.offset;
                FontMetrics fontMetrics = this.getFontMetrics();
                int n5 = segment.offset + segment.count - 1;
                for (int i = segment.offset; i <= n5; ++i) {
                    boolean bl2 = false;
                    if (Character.isWhitespace(segment.array[i])) {
                        if (!bl) {
                            bl2 = true;
                            bl = true;
                        }
                    } else {
                        if (bl) {
                            n4 = n3 = i;
                            bl = false;
                        } else {
                            n4 = i;
                        }
                        if (i == n5) {
                            bl2 = true;
                        }
                    }
                    if (!bl2 || n4 <= n3) continue;
                    f = Math.max(f, (float)fontMetrics.charsWidth(segment.array, n3, n4 - n3 + 1));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return f;
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet attributeSet = this.getAttributes();
        Object object = attributeSet.getAttribute(CSS.Attribute.TEXT_DECORATION);
        boolean bl = object != null ? object.toString().indexOf("underline") >= 0 : false;
        this.setUnderline(bl);
        boolean bl2 = object != null ? object.toString().indexOf("line-through") >= 0 : false;
        this.setStrikeThrough(bl2);
        Object object2 = attributeSet.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        bl2 = object2 != null ? object2.toString().indexOf("sup") >= 0 : false;
        this.setSuperscript(bl2);
        bl2 = object2 != null ? object2.toString().indexOf("sub") >= 0 : false;
        this.setSubscript(bl2);
        Object object3 = attributeSet.getAttribute(CSS.Attribute.WHITE_SPACE);
        this.nowrap = object3 != null && object3.equals("nowrap");
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        Color color = hTMLDocument.getBackground(attributeSet);
        if (color != null) {
            this.setBackground(color);
        }
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }
}

