/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.pipe;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.api.server.DocumentAddressResolver;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.developer.SchemaValidationFeature;
import com.sun.xml.internal.ws.developer.ValidationErrorHandler;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaValidationTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(AbstractSchemaValidationTube.class.getName());
    protected final WSBinding binding;
    protected final SchemaValidationFeature feature;
    protected final DocumentAddressResolver resolver = new ValidationDocumentAddressResolver();

    public AbstractSchemaValidationTube(WSBinding wSBinding, Tube tube) {
        super(tube);
        this.binding = wSBinding;
        this.feature = wSBinding.getFeature(SchemaValidationFeature.class);
    }

    protected AbstractSchemaValidationTube(AbstractSchemaValidationTube abstractSchemaValidationTube, TubeCloner tubeCloner) {
        super(abstractSchemaValidationTube, tubeCloner);
        this.binding = abstractSchemaValidationTube.binding;
        this.feature = abstractSchemaValidationTube.feature;
    }

    protected abstract Validator getValidator();

    protected abstract boolean isNoValidation();

    protected Document createDOM(SDDocument sDDocument) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        try {
            sDDocument.writeTo(null, this.resolver, byteArrayBuffer);
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        Transformer transformer = XmlUtil.newTransformer();
        StreamSource streamSource = new StreamSource(byteArrayBuffer.newInputStream(), null);
        DOMResult dOMResult = new DOMResult();
        try {
            transformer.transform(streamSource, dOMResult);
        }
        catch (TransformerException transformerException) {
            throw new WebServiceException(transformerException);
        }
        return (Document)dOMResult.getNode();
    }

    @Nullable
    protected void addSchemaFragmentSource(Document document, String string, List<Source> list) {
        Element element = document.getDocumentElement();
        assert (element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/"));
        assert (element.getLocalName().equals("definitions"));
        NodeList nodeList = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "types");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2 = ((Element)nodeList.item(i)).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2 = (Element)nodeList2.item(j);
                NamespaceSupport namespaceSupport = new NamespaceSupport();
                this.buildNamespaceSupport(namespaceSupport, element2);
                this.patchDOMFragment(namespaceSupport, element2);
                list.add(new DOMSource(element2, string + "#schema" + j));
            }
        }
    }

    private void buildNamespaceSupport(NamespaceSupport namespaceSupport, Node node) {
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        this.buildNamespaceSupport(namespaceSupport, node.getParentNode());
        namespaceSupport.pushContext();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if ("xmlns".equals(attr.getPrefix())) {
                namespaceSupport.declarePrefix(attr.getLocalName(), attr.getValue());
                continue;
            }
            if (!"xmlns".equals(attr.getName())) continue;
            namespaceSupport.declarePrefix("", attr.getValue());
        }
    }

    @Nullable
    private void patchDOMFragment(NamespaceSupport namespaceSupport, Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        Enumeration enumeration = namespaceSupport.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if ("xmlns".equals(attr.getPrefix()) && attr.getLocalName().equals("prefix")) continue;
                LOGGER.fine("Patching with xmlns:" + string + "=" + namespaceSupport.getURI(string));
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, namespaceSupport.getURI(string));
            }
        }
    }

    @Override
    public NextAction processRequest(Packet packet) {
        if (this.isNoValidation() || !packet.getMessage().hasPayload() || packet.getMessage().isFault()) {
            return super.processRequest(packet);
        }
        this.doProcess(packet);
        return super.processRequest(packet);
    }

    @Override
    public NextAction processResponse(Packet packet) {
        if (this.isNoValidation() || packet.getMessage() == null || !packet.getMessage().hasPayload() || packet.getMessage().isFault()) {
            return super.processResponse(packet);
        }
        this.doProcess(packet);
        return super.processResponse(packet);
    }

    private void doProcess(Packet packet) {
        ValidationErrorHandler validationErrorHandler;
        this.getValidator().reset();
        Class<? extends ValidationErrorHandler> clazz = this.feature.getErrorHandler();
        try {
            validationErrorHandler = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
        validationErrorHandler.setPacket(packet);
        this.getValidator().setErrorHandler(validationErrorHandler);
        Message message = packet.getMessage().copy();
        Source source = message.readPayloadAsSource();
        try {
            this.getValidator().validate(source);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    protected DOMSource toDOMSource(Source source) {
        if (source instanceof DOMSource) {
            return (DOMSource)source;
        }
        Transformer transformer = XmlUtil.newTransformer();
        DOMResult dOMResult = new DOMResult();
        try {
            transformer.transform(source, dOMResult);
        }
        catch (TransformerException transformerException) {
            throw new WebServiceException(transformerException);
        }
        return new DOMSource(dOMResult.getNode());
    }

    protected static void printDOM(DOMSource dOMSource) {
        try {
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            StreamResult streamResult = new StreamResult(byteArrayBuffer);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(dOMSource, streamResult);
            LOGGER.info("**** src ******" + byteArrayBuffer.toString());
            byteArrayBuffer.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class ValidationDocumentAddressResolver
    implements DocumentAddressResolver {
        private ValidationDocumentAddressResolver() {
        }

        @Nullable
        public String getRelativeAddressFor(@NotNull SDDocument sDDocument, @NotNull SDDocument sDDocument2) {
            LOGGER.fine("Current = " + sDDocument.getURL() + " resolved relative=" + sDDocument2.getURL());
            return sDDocument2.getURL().toExternalForm();
        }
    }
}

