/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlDataContentHandler
implements DataContentHandler {
    private final DataFlavor[] flavors = new DataFlavor[2];

    public XmlDataContentHandler() throws ClassNotFoundException {
        this.flavors[0] = new ActivationDataFlavor(StreamSource.class, "text/xml", "XML");
        this.flavors[1] = new ActivationDataFlavor(StreamSource.class, "application/xml", "XML");
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws IOException {
        for (DataFlavor dataFlavor2 : this.flavors) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return this.getContent(dataSource);
        }
        return null;
    }

    public Object getContent(DataSource dataSource) throws IOException {
        return new StreamSource(dataSource.getInputStream());
    }

    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (!string.equals("text/xml") && !string.equals("application/xml")) {
            throw new IOException("Invalid content type \"" + string + "\" for XmlDCH");
        }
        try {
            Transformer transformer = XmlUtil.newTransformer();
            StreamResult streamResult = new StreamResult(outputStream);
            if (object instanceof DataSource) {
                transformer.transform((Source)this.getContent((DataSource)object), streamResult);
            } else {
                transformer.transform((Source)object, streamResult);
            }
        }
        catch (Exception exception) {
            throw new IOException("Unable to run the JAXP transformer on a stream " + exception.getMessage());
        }
    }
}

