package tamanegisoul.pl.picasa;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.xmlpull.v1.XmlPullParser;

import tamanegisoul.pl.AppContext;
import tamanegisoul.pl.AppUtils;
import tamanegisoul.pl.CacheUtils;
import tamanegisoul.pl.data.AlbumInfo;
import tamanegisoul.pl.data.PhotoInfo;
import android.accounts.Account;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import android.util.Xml;

public class Picasa implements GetAuthTokenCallback {
    
    private static Picasa sInstance;
    
    public static void init(Account account) {
        sInstance = new Picasa(account);
    }
    
    public static boolean isInitiated() {
        return sInstance != null && sInstance.mAuthToken != null;
    }
    
    public static Picasa getInstance() {
        assert sInstance != null;
        return sInstance;
    }

    public final Account mAccount;
    private final String mUser;
    private String mAuthToken;

    private Picasa(Account account) {
        AppAccountManager.sInstance.getAuthToken(account, this);
        mAccount = account;
        mUser = account.name.substring(0, account.name.indexOf('@'));
    }

    public ArrayList<Object[]> getAlbumList() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        try {
            String url = String
                    .format(
                            "https://picasaweb.google.com/data/feed/api/user/%s?kind=album&access=all&v=2.0&fields=entry(title,link,media:group(media:thumbnail),gphoto:numphotos)",
                            new Object[] { mUser });
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpGet(url)));
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(reader);

            String currentElement = "";
            for (int eventType = parser.getEventType(); eventType != XmlPullParser.END_DOCUMENT; eventType = parser.next()) {
                switch (eventType) {
                case XmlPullParser.START_TAG:
                    currentElement = parser.getName();
                    if (currentElement.equals("link") && parser.getAttributeValue(null, "rel").equals("http://schemas.google.com/g/2005#feed")) {
                        list.get(list.size() - 1)[1] = parser.getAttributeValue(null, "href");
                    }
                    if (currentElement.equals("thumbnail")) {
                        list.get(list.size() - 1)[2] = getPhoto(parser.getAttributeValue(null, "url"));
                    }
                    break;
                case XmlPullParser.TEXT:
                    if (currentElement.equals("title")) {
                        Object[] values = new Object[] { parser.getText(), null, null };
                        list.add(values);
                    }
                    break;
                }
            }

            reader.close();
        } catch (Exception e) {
            Log.e(AppContext.NAME, "", e);
        }
        return list;
    }

    /**
     * アルバム情報を取得する。
     * @return アルバム名、URL、写真数の配列のコレクション
     */
    public ArrayList<AlbumInfo> getAlbumInfos() {
        ArrayList<AlbumInfo> list = new ArrayList<AlbumInfo>();
        try {
            String url = String.format(
                    "https://picasaweb.google.com/data/feed/api/user/%s?kind=album&access=all&v=2.0&fields=entry(title,link,gphoto:numphotos)",
                    new Object[] { mUser });
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpGet(url)));
            
            // TODO
//            String s = reader.readLine();
//            Log.d(AppContext.NAME, s);
//            reader = new BufferedReader(new StringReader(s));
            
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(reader);

            String currentElement = "";
            String[] currentValues = null;
            for (int eventType = parser.getEventType(); eventType != XmlPullParser.END_DOCUMENT; eventType = parser.next()) {
                switch (eventType) {
                case XmlPullParser.START_TAG:
                    currentElement = parser.getName();
                    Log.d(AppContext.NAME, String.format("currentElement:%s", currentElement));
                    if (currentElement.equals("link") && parser.getAttributeValue(null, "rel").equals("http://schemas.google.com/g/2005#feed")) {
                        currentValues[1] = parser.getAttributeValue(null, "href");
                    }
                    break;
                case XmlPullParser.TEXT:
                    if (currentElement.equals("title")) {
                        currentValues = new String[] { parser.getText(), null };
                    } else if (currentElement.equals("numphotos")) {
                        AlbumInfo info = new AlbumInfo(currentValues[0], currentValues[1], Integer.valueOf(parser.getText()));
                        Log.d(AppContext.NAME, String.format("albumInfo: %s", info.toString()));
                        list.add(info);
                    }
                    break;
                }
            }

            reader.close();
        } catch (Exception e) {
            Log.e(AppContext.NAME, "", e);
        }
        return list;
    }

    public InputStream httpGet(String url) throws ClientProtocolException, IOException {
        Log.d(AppContext.NAME, String.format("downloading %s ", url));
        HttpGet request = new HttpGet(url);
        request.setHeader("Authorization", "GoogleLogin auth=" + mAuthToken);
        Log.d(AppContext.NAME, mAuthToken);
        HttpClient httpclient = new DefaultHttpClient();
        HttpResponse response = (HttpResponse) httpclient.execute(request);

        if (response.getEntity().getContentType().getValue().equals("text/plain")) {
            AppAccountManager.sInstance.getAuthToken(mAccount, this);
            Log.d(AppContext.NAME, "たぶんToken expired");
            String content = AppUtils.getContent(response.getEntity().getContent(), response.getEntity().getContentEncoding().getValue());
            Log.d(AppContext.NAME, content);
            // throw new TokenExpiredException();
        }

        return new BufferedHttpEntity(response.getEntity()).getContent();
    }

    public ArrayList<PhotoInfo> getPhotoList(AlbumInfo albumInfo) {
        ArrayList<PhotoInfo> photoInfos = new ArrayList<PhotoInfo>();
        try {
            String url = albumInfo.link + "&fields=entry(title,media:group(media:content))";
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpGet(url)));
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(reader);

            String currentTag = "";
            String title = null;
            for (int eventType = parser.getEventType(); eventType != XmlPullParser.END_DOCUMENT; eventType = parser.next()) {
                switch (eventType) {
                case XmlPullParser.START_TAG:
                    currentTag = parser.getName();
                    if (currentTag.equals("content") && parser.getNamespace().equals("http://search.yahoo.com/mrss/")) {
                        assert title != null;
                        photoInfos.add(new PhotoInfo(title, parser.getAttributeValue(null, "url")));
                    }
                    break;
                case XmlPullParser.TEXT:
                    if (currentTag.equals("title"))
                        title = parser.getText();
                    break;
                }
            }
            reader.close();
        } catch (Exception e) {
            Log.e(AppContext.NAME, "", e);
        }
        return photoInfos;
    }

    public void cache(Context context, AlbumInfo albumInfo) {
        try {
            String url = albumInfo.link + "&fields=entry(title,media:group(media:content))";
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpGet(url)));
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(reader);

            int count = 0;
            String currentTag = "";
            String title = null;
            for (int eventType = parser.getEventType(); eventType != XmlPullParser.END_DOCUMENT; eventType = parser.next()) {
                switch (eventType) {
                case XmlPullParser.START_TAG:
                    currentTag = parser.getName();
                    if (currentTag.equals("content") && parser.getNamespace().equals("http://search.yahoo.com/mrss/")) {
                        assert title != null;
                        if (count++ > 3) {
                            break;
                        }
                        InputStream in = httpGet(parser.getAttributeValue(null, "url"));
                        CacheUtils.cache(albumInfo.title, title, in);
                        in.close();
                    }
                    break;
                case XmlPullParser.TEXT:
                    if (currentTag.equals("title"))
                        title = parser.getText();
                    break;
                }
            }
            reader.close();
        } catch (Exception e) {
            Log.e(AppContext.NAME, "", e);
        }
    }

    public Bitmap getPhoto(String imageUrl) {
        Bitmap bitmap = null;
        try {
            BufferedInputStream in = new BufferedInputStream(httpGet(imageUrl));
            bitmap = BitmapFactory.decodeStream(in);

            // Matrix matrix = new Matrix();
            // matrix.postScale(0.5f, 0.5f);
            // Bitmap scaledBitmap = Bitmap.createBitmap(bm, 0, 0,
            // bm.getWidth(), bm.getHeight(), matrix, true);
            // bm = scaledBitmap;

            in.close();

            // Bitmap bm = BitmapFactory.decodeStream(c.getInputStream());

            // ImageView iv = (ImageView) findViewById(R.id.imgv);
            // iv.setImageBitmap(bm);
            // iv.setClickable(true);
            // iv.invalidate();
        } catch (Exception e) {
            // TODO: handle exception
        }
        return bitmap;
    }

    @Override
    public void gotToken(String token) {
        this.mAuthToken = token;
    }
}
