/*
 * Decompiled with CFR 0.152.
 */
public class VariableCRC32 {
    private int crc;
    private int poly;

    public VariableCRC32(int polynomial, int initialValue) {
        this.poly = polynomial;
        this.crc = initialValue;
    }

    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    public void reset(int initialValue) {
        this.crc = initialValue;
    }

    public void addByte(int value) {
        for (int counter = 0; counter < 8; counter = (int)((char)(counter + 1))) {
            int crcnext = 0;
            if ((this.crc & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                crcnext = 1;
            }
            this.crc <<= 1;
            if ((crcnext ^= value & 1) != 0) {
                this.crc ^= this.poly;
            }
            value >>= 1;
        }
    }
}

