<?php
class phpdao_dao_querybuilder
{
  public static function select($table,$columns='*',$where=array(),$join_tables=null) // {{{
  {
    phpdao_factory::get_schema($table); // check table

    if($join_tables != null)
      $join = ','.join(',',$this->join_tables);
    $query = "select $columns from {$table}$join".self::array_to_where($table,$where);
    return $query;
  } // }}}
  public static function insert($table,$values = array()) // {{{
  {
    phpdao_factory::get_schema($table); // check table

    $sql_set = array();
    foreach( $values as $column => $field )
      $sql_set[] = self::quote($table,$column,$field);

    $columns = array_keys($values);

    $query = "insert into $table (".join(',',$columns).") values (".join(',',$sql_set).")";
    return $query;
  } // }}}
  public static function update($table,$values,$where=array()) // {{{
  {
    phpdao_factory::get_schema($table); // check table

    $sql_set = array();
    foreach( $values as $column => $field )
      $sql_set[] = "$column=".self::quote($table,$column,$field);

    $sql_set = join(',',$sql_set);

    $sql = "update {$table} set $sql_set".self::array_to_where($table,$where);
    return $sql;
  } // }}}
  public static function delete($table,$where=array()) // {{{
  {
    phpdao_factory::get_schema($table); // check table

    $sql = "delete from {$table}".self::array_to_where($table,$where);
    return $sql;
  } // }}}

  public static function array_to_where($table_name,$array)//{{{
  {
    if( !is_array($array) )
      throw new exception('array need array()');

    $where = array();
    foreach( $array as $key => $val )
    {
      if ($key == '@sql' )
        $where[] = "($val)";
      else
        if($val == null)
          $where[] = "$key is NULL";
        else
          $where[] = "$key = ".self::quote($table_name,$key,$val );
    }
    if (count($where))
      $qr = " where ".join(' and ',$where);
    else 
      $qr = '';
    return $qr;
  }//}}}
  public static function quote($table_name,$col_name,$val) //{{{
  {
    $col = phpdao_factory::get_schema($table_name,$col_name);
    switch( $col['type'] )
    {
    case null:
      throw new exception("phpdao_factory error:no column name:[$table_name.$col_name]");
    case 'varchar':
    case 'char':
    case 'text':
      $val = "'".str_replace("'","''",$val)."'";
      break;
    case 'bigint':
    case 'int':
      break;
    default:
      throw new exception("phpdao_factory type not supported:[$table_name.$col_name.{$col['type']}]");
      break;
    }
    return $val;
  }//}}}
}
