<?php
class phpdao_dao_base
{
  protected $__where = array(); 
  protected $__attached = false;

  public function where($where)//{{{
  {
    $this->__where = $where;
    return $this;
  }//}}}
  public function fetch()//{{{
  {
    if( null === $this->__table_name )
      throw new exception("Error:{$this->__table_name}::fetch() table_name is null.");

    $db = phpdao_db::get();
    $sql = phpdao_dao_querybuilder::select($this->__table_name,'*',$this->__where);
    if($db->query($sql))
    {
      $row = $db->fetch_row();
      if( false != $row)
        $this->attach($row);
    }
    $db->close();
    return $this;
  }//}}}

  public function get_link($target_table_name) //{{{
  {
    $relation = phpdao_factory::get_relation($this->__table_name,$target_table_name);
    $source_column = $relation['source']['column'];
    $where = $this->$source_column;
    $item = phpdao_factory::get_item($relation['target']['table'],
                                       array($relation['target']['column']=>$where));
    return $item;

  }//}}}
  public function get_links($target_table_name) //{{{
  {
    $relation = phpdao_factory::get_relation($this->__table_name,$target_table_name);
    $source_column = $relation['source']['column'];
    $where = $this->$source_column;
    $items = phpdao_factory::get_items($relation['target']['table'],
                                        array($relation['target']['column']=>$where));

    return $items;
  }//}}}

  public function update() // {{{
  {
    $primary_key  = phpdao_factory::get_primary_key($this->__table_name);
    $schema       = phpdao_factory::get_schema($this->__table_name);
    unset($schema['@primary_key']);
    unset($schema[$primary_key]);

    if( !isset($this->$primary_key ) )
      throw new exception("{$this->__table_name}:primary key doesn't set");

    $columns = array();
    foreach( $schema as $column => $field )
    {
      $columns[$column] = $this->$column;
    }

    $sql = phpdao_dao_querybuilder::update($this->__table_name,$columns);

    $db = phpdao_db::get();
    if(!$db->query($sql))
      throw new exception("{$this->__table_name}:update failed:[$sql]");
  } // }}}
  public function delete() // {{{
  {
    $primary_key  = phpdao_factory::get_primary_key($this->__table_name);
    if( !isset($this->$primary_key ) )
      throw new exception("{$this->__table_name}:primary key doesn't set");

    $sql = phpdao_dao_querybuilder::delete($this->__table_name,array($primary_key=>$this->$primary_key));

    $db = phpdao_db::get();
    if(!$db->query($sql))
      throw new exception("{$this->__table_name}:delete failed:[$sql]");

  } // }}}
  public function insert() //{{{
  {
    $primary_key  = phpdao_factory::get_primary_key($this->__table_name);
    $schema       = phpdao_factory::get_schema($this->__table_name);
    unset($schema['@primary_key']);
    unset($schema[$primary_key]);

    if( isset($this->$primary_key ) )
      throw new exception("{$this->__table_name}:primary key already set");

    $columns = array();
    foreach( array_keys($columns) as $column_name => $field )
    {
      $columns[$column] = $this->$column;
    }
    $sql = phpdao_dao_querybuilder::insert($this->__table_name,$columns);

    $db = phpdao_db::get();
    if(!$db->query($sql))
      throw new exception("{$this->__table_name}:insert failed:[$sql]");
    return $this->$primary_key = $db->last_insert_id();
  } //}}}

  public function attach($row)//{{{
  {
    foreach( $row as $key => $val )
    {
      $this->$key = $val;
    }
    $this->__attached = true;
  }//}}}
  public function is_attached() // {{{
  {
    return $this->__attached;
  } // }}}
}

