<?php
if (!defined("PHPUnit2_MAIN_METHOD")) {
      define("PHPUnit2_MAIN_METHOD", "test_phpdao_table::main");
}
require_once "../src/cfg.php";
require_once "../src/db.php";
require_once "../src/dao/base.php";
require_once "../src/factory.php";
require_once "../src/dao/schema.php";
require_once "PHPUnit2/Framework/IncompleteTestError.php";
require_once "PHPUnit2/Framework/TestCase.php";
require_once "PHPUnit2/Framework/TestSuite.php";
require_once "PHPUnit2/TextUI/TestRunner.php";
/**
 * Test class for phpdao_db.
 * Generated by PHPUnit2_Util_Skeleton on 2005-04-23 at 23:15:11.
 */
class test_phpdao_table extends PHPUnit2_Framework_TestCase {
    static $user = array( //{{{
          0 => array(
                'loginname' =>'loginname1',
                'nickname'  =>'nickname1',
                'passwd'    =>'pwd1',
                'regdate'   =>'2000-01-01 00:00:00',
                ),
          1 => array(
                'loginname' =>'loginname2',
                'nickname'  =>'nickname2',
                'passwd'    =>'pwd2',
                'regdate'   =>'2001-01-01 00:00:00',
                ),
        ); //}}}
    static $memo = array( //{{{
          0 => array(
                'srl'       =>1,
                'usn'        =>1,
                'url'        =>'http://www.google.co.jp/',
                'comment'    =>'コメント',
                ),
        ); //}}}

    public static function main() { //{{{
        $suite  = new PHPUnit2_Framework_TestSuite("test_phpdao_table");
        $result = PHPUnit2_TextUI_TestRunner::run($suite);
    } //}}}
    /**
    /**
    * @todo fetch imprement
    */
    public function test_fetch() { //{{{
      $user = phpdao_factory::create_table_class('user');
      $user->where(array('usn'=>1))->fetch();
      if( false === $this->object_comp_recursive(self::$user[0],$user) )
        throw new PHPUnit2_Framework_IncompleteTestError('table user failed.');
    } //}}}
    /**
    * @todo get_links imprement
    */
    public function test_get_links() { //{{{
      $user = phpdao_factory::create_table_class('user');
      $user->where(array('usn'=>1))->fetch();
      $array_memo = $user->get_links('memo');
      if( false === $this->object_comp_recursive(self::$memo,$array_memo) )
        throw new PHPUnit2_Framework_IncompleteTestError();
    } //}}}
    /**
    * @todo get_link imprement
    */
    public function test_get_link() { //{{{
      $user = phpdao_factory::create_table_class('user')->where(array('usn'=>1))->fetch();
      $memo = $user->get_link('memo');
      if( false === $this->object_comp_recursive(self::$memo[0],$memo) )
        throw new PHPUnit2_Framework_IncompleteTestError();
    } //}}}
    /**
    * @todo get_update imprement
    */
    public function test_update() { //{{{
      $user = phpdao_factory::create_table_class('user');
      $user->where(array('usn'=>1))->fetch();
      $user->nickname = 'changed';
      $user->update();

      $user_changed = phpdao_factory::create_table_class('user');
      $user_changed->where(array('usn'=>1))->fetch();
      if( false === $this->object_comp_recursive($user,$user_changed) )
        throw new PHPUnit2_Framework_IncompleteTestError();

      $user_changed->nickname = 'nickname1';
      $user_changed->update();

    } //}}}
    /**
    * @todo get_insert_and_delete imprement
    */
    public function test_insert_and_delete() { //{{{
      try
      {
        $user = phpdao_factory::create_table_class('user');
        $user->loginname = 'insertlogin';
        $user->nickname  = 'insertnick';
        $user->passwd    = 'insertpasswd';
        $user->regdate   = 'xxxxxxxxxxxx';
        $nexval = $user->insert();

        $user->delete();
      }catch(exception $e)
      {
        throw new PHPUnit2_Framework_IncompleteTestError($e->getMessage());
      }
    } //}}}



    public function object_comp_recursive($obj1, $obj2) //{{{
    {
      foreach($obj1 as $key => $val )
      {
        if( substr(0,2,$key) == '__')
          continue;

        if( is_array($val) || is_object($val))
        {
          if( false == $this->object_comp_recursive($val,$obj2[$key]) )
            return false;
          else
            continue;
        }

        if( $obj->$key == $obj2->$key )
          return false;

        if( array_key_exists($key, $obj2) )
          if( $val != $obj2->$key )
            return false;
      }
      return true;
    } //}}}
}
if (PHPUnit2_MAIN_METHOD == "test_phpdao_table::main") {
    test_phpdao_table::main();
}
