<?php
if (!defined("PHPUnit2_MAIN_METHOD")) {
      define("PHPUnit2_MAIN_METHOD", "test_phpdao_dao_db::main");
}
require_once "../src/db.php";
require_once "PHPUnit2/Framework/IncompleteTestError.php";
require_once "PHPUnit2/Framework/TestCase.php";
require_once "PHPUnit2/Framework/TestSuite.php";
require_once "PHPUnit2/TextUI/TestRunner.php";
/**
 * Test class for phpdao_db.
 * Generated by PHPUnit2_Util_Skeleton on 2005-04-23 at 23:15:11.
 */
class test_phpdao_dao_db extends PHPUnit2_Framework_TestCase {
    static $db = null; 
    static $data = array( //{{{
            array(
                  'loginname'=>'loginname1',
                  'nickname'=>'nickname1',
                  'passwd'=>'pwd1',
                  'regdate'=>'2000-01-01 00:00:00',
              ),
            array(
                  'loginname'=>'loginname2',
                  'nickname'=>'nickname2',
                  'passwd'=>'pwd2',
                  'regdate'=>'2001-01-01 00:00:00',
              ),
            ); //}}}

    public static function main() { //{{{
        $suite  = new PHPUnit2_Framework_TestSuite("test_phpdao_dao_db");
        $result = PHPUnit2_TextUI_TestRunner::run($suite);
    } //}}}
    /**
    * @todo DBへの接続テスト
    */
    public function test_get() { //{{{
      try
      {
        $db = phpdao_db::get();
        if ($db === null)
          throw new exception('phpdao_db::get()');

        if( $db !== phpdao_db::get() )
          throw new exception('phpdao_db::get()');

      }catch(exception $e)
      {
        throw new PHPUnit2_Framework_IncompleteTestError;
      }
    } //}}}
    /**
    * @todo Queryのテスト
    */
    public function test_query() { //{{{
      try
      {
        $db = phpdao_db::get();
        if (false === $db->query("select * from user"))
          throw new exception('query error');

        $ok = false;
        try{
          if (false === $db->query("select * from non_exists_table"))
            throw new exception('query error');
        }catch(exception $e)
        {
          $ok = true;
        }

        if( $ok !== true )
        {
          throw new exception('query error');
        }
        $db->close();

      }catch (exception $e)
      {
        throw new PHPUnit2_Framework_IncompleteTestError($e->getMessage());
      }
    } //}}}
    /**
    * @todo Implement test_fetch_row().
    */
    public function test_fetch_row() {  ///{{{
      return;
      $query = "select * from user order by loginname asc";
      $db = phpdao_db::get();
      if ($db->query($query))
      {
        $row = $db->fetch_row();
        if( false === $row  )
          throw new PHPUnit2_Framework_IncompleteTestError('return value is false.');

        if( $data[0] != $row )
          throw new PHPUnit2_Framework_IncompleteTestError('data not same');
      } 
      $db->close();
    } //}}}
    /**
    * @todo Implement test_fetch_all_row().
    */
    public function test_fetch_all_row() { //{{{
      $db = phpdao_db::get();
      $query = "select * from user order by loginname asc";
      if ($db->query($query))
      {
        $rows = $db->fetch_all_row();
        if( false == $rows )
          throw new PHPUnit2_Framework_IncompleteTestError('phpdao_db::getch_all_row()');
        for ($i = 0; $i < count($data); $i++ )
          if($data[$i] != $rows[$i] )
          throw new PHPUnit2_Framework_IncompleteTestError('phpdao_db::getch_all_row()');
      }
      $db->close();
    } //}}}
}
if (PHPUnit2_MAIN_METHOD == "test_phpdao_dao_db::main") {
    test_phpdao_dao_db::main();
}
