<?php
require_once 'cfg.php';

class phpdao_db
{
  public static $schema = null;
  public static $myself = null;

  protected $dsn = null;
  protected $db = null;
  protected $result = null;
  protected $statement = null;

  function __construct()//{{{
  {
    $this->dsn  = phpdao_cfg::get('db.type').":host=".phpdao_cfg::get('db.host').";dbname=".phpdao_cfg::get('db.dbname');
    $user = phpdao_cfg::get('user');
    $pass = phpdao_cfg::get('pass');

    $this->db = new PDO($this->dsn, $user, $pass);
    $this->db->setAttribute(PDO::ATTR_CASE, PDO::CASE_LOWER);  // カラム名を小文字で取得する
    //$db->setAttribute(PDO_ATTR_AUTOCOMMIT, 0); // auto commit off
    $this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); //  Error時に例外をthrowする
    if( phpdao_cfg::get('db.type') == 'mysql' )
      $this->db->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,true);
  }//}}}
  static function get() //{{{
  {
    if (self::$myself !== null )
    {
      return self::$myself;
    }
    return (self::$myself = new phpdao_db);
  }//}}}

  function query($query)//{{{
  {
    $this->statement = $this->db->prepare($query);
    return $this->statement->execute();
  }//}}}
  function fetch_row($option=PDO::FETCH_NAMED)//{{{
  {
    return $this->statement->fetch($option);
  }//}}}
  function fetch_all_row($option=PDO::FETCH_NAMED)//{{{
  {
    $rows = array();
    while( false !== ($row = $this->fetch_row($option)) )
    {
      $rows[] = $row;
    }
    return $rows; 
  }//}}}
  function last_insert_id() //{{{
  {
    return $this->db->lastInsertId();
  } //}}}

  function close() //{{{
  {
    if( null != $this->statement )
    {
      $this->statement->closeCursor();
      $this->statement = null;
    }
    return true;
  } //}}}
}

