package org.phosphoresce.commons.util;

import junit.framework.TestCase;

/**
 * ByteFIFOStackクラステストケース<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/06	Kitagawa		新規作成
 *-->
 */
public class TestByteFIFOStack extends TestCase {

	public void testPushPop() throws Throwable {
		ByteFIFOStack stack = new ByteFIFOStack(4);
		byte[] bytes = null;
		bytes = stack.push("1".getBytes());
		assertEquals(new String(bytes), "");
		assertEquals(new String(stack.getBytes()), "1");
		bytes = stack.push("2".getBytes());
		assertEquals(new String(bytes), "");
		assertEquals(new String(stack.getBytes()), "12");
		bytes = stack.push("3".getBytes());
		assertEquals(new String(bytes), "");
		assertEquals(new String(stack.getBytes()), "123");
		bytes = stack.push("4".getBytes());
		assertEquals(new String(bytes), "");
		assertEquals(new String(stack.getBytes()), "1234");
		bytes = stack.push("5".getBytes());
		assertEquals(new String(bytes), "1");
		assertEquals(new String(stack.getBytes()), "2345");
		bytes = stack.push("6".getBytes());
		assertEquals(new String(bytes), "2");
		assertEquals(new String(stack.getBytes()), "3456");
		bytes = stack.push("78".getBytes());
		assertEquals(new String(bytes), "34");
		assertEquals(new String(stack.getBytes()), "5678");
		bytes = stack.pop();
		assertEquals(new String(bytes), "5");
		assertEquals(new String(stack.getBytes()), "678");
		bytes = stack.pop(2);
		assertEquals(new String(bytes), "67");
		assertEquals(new String(stack.getBytes()), "8");
		bytes = stack.pop(3);
		assertEquals(new String(bytes), "8");
		assertEquals(new String(stack.getBytes()), "");
	}

	public void testPushNegative() throws Throwable {
		ByteFIFOStack stack = new ByteFIFOStack(-10);
		byte[] bytes = stack.push("1234567890".getBytes());
		assertEquals(new String(bytes), "1234567890");
		assertEquals(new String(stack.getBytes()), "");
	}

	public void testPushZero() throws Throwable {
		ByteFIFOStack stack = new ByteFIFOStack(0);
		byte[] bytes = stack.push("1234567890".getBytes());
		assertEquals(new String(bytes), "1234567890");
		assertEquals(new String(stack.getBytes()), "");
	}

	public void testPushOne() throws Throwable {
		ByteFIFOStack stack = new ByteFIFOStack(4);
		byte[] bytes = stack.push("1234567890".getBytes());
		assertEquals(new String(bytes), "123456");
		assertEquals(new String(stack.getBytes()), "7890");
	}

	public void testPushSameSize() throws Throwable {
		ByteFIFOStack stack = new ByteFIFOStack(10);
		byte[] bytes = stack.push("1234567890".getBytes());
		assertEquals(new String(bytes), "");
		assertEquals(new String(stack.getBytes()), "1234567890");
	}

	public void testPushOver() throws Throwable {
		ByteFIFOStack stack = new ByteFIFOStack(20);
		byte[] bytes = stack.push("1234567890".getBytes());
		assertEquals(new String(bytes), "");
		assertEquals(new String(stack.getBytes()), "1234567890");
	}

	public void testPushJapanese() throws Throwable {
		ByteFIFOStack stack = new ByteFIFOStack(4);
		byte[] bytes = stack.push("あいうえお".getBytes());
		assertEquals(new String(bytes), "あいう");
		assertEquals(new String(stack.getBytes()), "えお");
	}

	public void testPushMultipleExec() throws Throwable {
		ByteFIFOStack stack = new ByteFIFOStack(4);
		byte[] bytes = null;
		bytes = stack.push("1234567890".getBytes());
		bytes = stack.push("ABCDEFGHIJ".getBytes());
		assertEquals(new String(bytes), "7890ABCDEF");
		assertEquals(new String(stack.getBytes()), "GHIJ");
	}
}

