package org.phosphoresce.commons.ldaps;

import junit.framework.TestCase;

/**
 * LDAPManagerテストケースクラス<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/28	Kitagawa		新規作成
 *-->
 */
public class TestLDAPManager extends TestCase {

	private LDAPManagerConfig config;

	private LDAPManager manager;

	/**
	 * @throws Exception
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		config = new LDAPManagerConfig();
		config.setHost("examserver");
		config.setPort(389);
		config.setVersion(3);
		config.setBaseDn("dc=examhost,dc=examdomain");
		config.setAnonymousBind(false);
		config.setSslConnection(false);
		config.setUserDn("cn=Manager,dc=examhost,dc=examdomain");
		config.setUserPassword("secret");
		config.setSearchScope(LDAPManagerConfig.SEARCH_SCOPE_ONELEVEL);
		config.setCountLimit(0);
		config.setTimeLimit(0);
		config.setDerefLink(false);
		config.setReturnObject(false);

		manager = new LDAPManager(config);
	}

	public void testAdd() throws Throwable {
		final String DN = "uid=foo,ou=users,dc=examhost,dc=examdomain";

		LDAPEntry entry = new LDAPEntry();
		entry.addAttribute("objectClass", "top");
		entry.addAttribute("objectClass", "person");
		entry.addAttribute("objectClass", "organizationalPerson");
		entry.addAttribute("objectClass", "inetOrgPerson");
		entry.addAttribute("userPassword", "secret");
		entry.addAttribute("uid", "foo");
		entry.addAttribute("cn", "foo");
		entry.addAttribute("sn", "foo");

		manager.add(DN, entry);
	}

	public void testSearch() throws Throwable {
		final String DN = "ou=users,dc=examhost,dc=examdomain";
		final String FILTER = "(uid=foo)";

		LDAPEntry[] entries = manager.search(DN, FILTER);

		assertEquals(1, entries.length);
	}

	public void testUpdate() throws Throwable {
		final String DN = "ou=users,dc=examhost,dc=examdomain";
		final String FILTER = "(uid=foo)";

		LDAPEntry[] entries = manager.search(DN, FILTER);

		assertEquals(1, entries.length);

		LDAPEntry entry = entries[0];
		LDAPAttribute attribute = entry.getAttribute("cn");
		attribute.setValue(0, "test");
		entry.addAttribute("cn", "test2");

		manager.update("uid=foo," + DN, entry);
	}

	public void testDelete() throws Throwable {
		final String DN = "uid=foo,ou=users,dc=examhost,dc=examdomain";

		manager.delete(DN);
	}
}

