package org.phosphoresce.commons.util;

import java.io.Serializable;

/**
 * オブジェクトビーンクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/07	Kitagawa		新規作成
 *-->
 */
public class ValueBean implements Serializable {

	/** キー */
	private Object key;

	/** 値 */
	private Object value;

	/**
	 * コンストラクタ<br>
	 * @param key キー
	 * @param value 値
	 */
	public ValueBean(Object key, Object value) {
		super();
		this.key = key;
		this.value = value;
	}

	/**
	 * コンストラクタ<br>
	 */
	public ValueBean() {
		this(null, null);
	}

	/**
	 * キーを取得します。<br>
	 * @return キー
	 */
	public Object getKey() {
		return key;
	}

	/**
	 * キーを設定します。<br>
	 * @param key キー
	 */
	public void setKey(Object key) {
		this.key = key;
	}

	/**
	 * 値を取得します。<br>
	 * @return 値
	 */
	public Object getValue() {
		return value;
	}

	/**
	 * 値を設定します。<br>
	 * @param value 値
	 */
	public void setValue(Object value) {
		this.value = value;
	}

	/**
	 * オブジェクトハッシュコードを取得します。<br>
	 * @return オブジェクトハッシュコード
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((key == null) ? 0 : key.hashCode());
		result = prime * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}

	/**
	 * 指定されたオブジェクトの等価を判断します。<br>
	 * @param object 比較対象オブジェクト
	 * @return 対象オブジェクトが等価である場合trueを返却
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		if (object == null) {
			return false;
		}
		if (getClass() != object.getClass()) {
			return false;
		}
		ValueBean other = (ValueBean) object;
		if (key == null) {
			if (other.key != null) {
				return false;
			}
		} else if (!key.equals(other.key)) {
			return false;
		}
		if (value == null) {
			if (other.value != null) {
				return false;
			}
		} else if (!value.equals(other.value)) {
			return false;
		}
		return true;
	}
}
