package org.phosphoresce.commons.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * リストオブジェクトに対する操作を行うメソッドを提供するクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2009/12/28	Kitagawa		新規作成
 *-->
 */
public final class ListUtil {

	/**
	 * コンストラクタ<br>
	 */
	private ListUtil() {
		//
	}

	/**
	 * 重複しているリスト要素を削除します。<br>
	 * 当メソッドは直接指定されたリストオブジェクトを操作することに注意してください。<br>
	 * @param list 編集するリストオブジェクト
	 */
	public static void removeDupulicateEntry(List list) {
		if (list == null || list.size() == 0) {
			return;
		}
		List buffer = new LinkedList();
		for (Iterator iterator = list.iterator(); iterator.hasNext();) {
			Object entry = iterator.next();
			if (!buffer.contains(entry)) {
				buffer.add(entry);
			}
		}
		list.clear();
		for (Iterator iterator = buffer.iterator(); iterator.hasNext();) {
			list.add(iterator.next());
		}
	}
}
