package org.phosphoresce.commons.util;

import java.io.Serializable;

/**
 * コマンド実行結果保持クラス<br>
 * <br>
 * 当クラスは{@link CommandUtil}より使用される実行結果内容を保持するクラスです。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/05	Kitagawa		新規作成
 *-->
 */
public final class CommandResult implements Serializable {

	/** リターンコード */
	private int code;

	/** コンソール出力内容 */
	private String output;

	/** エラー出力内容 */
	private String error;

	/** コマンド実行時例外 */
	private Throwable exception;

	/**
	 * コンストラクタ<br>
	 */
	CommandResult() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param code リターンコード
	 * @param output コンソール出力内容
	 * @param error エラー出力内容
	 * @param exception コマンド実行時例外
	 */
	CommandResult(int code, String output, String error, Throwable exception) {
		super();
		this.code = code;
		this.output = output;
		this.error = error;
		this.exception = exception;
	}

	/**
	 * リターンコードを取得します。<br>
	 * @return リターンコード
	 */
	public int getCode() {
		return code;
	}

	/**
	 * リターンコードを設定します。<br>
	 * @param code リターンコード
	 */
	void setCode(int code) {
		this.code = code;
	}

	/**
	 * コンソール出力内容を取得します。<br>
	 * @return コンソール出力内容
	 */
	public String getOutput() {
		return output;
	}

	/**
	 * コンソール出力内容を設定します。<br>
	 * @param output コンソール出力内容
	 */
	public void setOutput(String output) {
		this.output = output;
	}

	/**
	 * エラー出力内容を取得します。<br>
	 * @return エラー出力内容
	 */
	public String getError() {
		return error;
	}

	/**
	 * エラー出力内容を設定します。<br>
	 * @param error エラー出力内容
	 */
	public void setError(String error) {
		this.error = error;
	}

	/**
	 * コマンド実行時例外を取得します。<br>
	 * @return コマンド実行時例外
	 */
	public Throwable getException() {
		return exception;
	}

	/**
	 * コマンド実行時例外を設定します。<br>
	 * @param exception コマンド実行時例外
	 */
	public void setException(Throwable exception) {
		this.exception = exception;
	}

	/**
	 * コンソール出力内容が存在するか判定します。<br>
	 * @return コンソール出力内容が存在する場合にtrueを返却
	 */
	public boolean hasOutput() {
		return !StringUtil.isEmpty(output);
	}

	/**
	 * エラー出力内容が存在するか判定します。<br>
	 * @return エラー出力内容が存在する場合にtrueを返却
	 */
	public boolean hasError() {
		return !StringUtil.isEmpty(error);
	}

	/**
	 * コマンド実行時例外が存在するか判定します。<br>
	 * @return コマンド実行時例外が存在する場合にtrueを返却
	 */
	public boolean hasException() {
		return exception != null;
	}
}

